% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regen.R
\name{Regen}
\alias{Regen}
\title{Regenerate a coin or purse}
\usage{
Regen(x, from = NULL, quietly = TRUE)
}
\arguments{
\item{x}{A coin or purse object to be regenerated}

\item{from}{Optional: a construction function name. If specified, regeneration begins from this function, rather
than re-running all functions.}

\item{quietly}{If \code{TRUE} (default), messages are suppressed during building.}
}
\value{
A regenerated object
}
\description{
Methods for regenerating coins and purses. Regeneration is re-running all the functions used to build
the coin/purse, using the order and parameters found in the \code{.$Log} list of the coin.
}
\details{
Please see individual method documentation:
\itemize{
\item \code{\link[=Regen.coin]{Regen.coin()}}
\item \code{\link[=Regen.purse]{Regen.purse()}}
}

See also \code{vignette("adjustments")}.
}
\examples{
# see individual method examples

}
