% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_resultsdash.R
\name{resultsDash}
\alias{resultsDash}
\title{Results visualisation dashboard}
\usage{
resultsDash(COIN, dset = "Aggregated")
}
\arguments{
\item{COIN}{The COIN object}

\item{dset}{The initial data set to explore.}
}
\value{
Interactive app for exploring results (if running an interactive R session). Otherwise will simply generate a message.
}
\description{
Generates an interactive visualisation of results. Requires Shiny and an interactive R session.
}
\details{
This function provides a fast way to present and explore results in a COIN. It plots interactive bar charts of any indicator
or aggregate, and maps if the unit codes are ISO alpha-3 country codes. It also includes an interactive results table, and the
possibility to quickly compare units on a radar chart.
}
\examples{
# To be run in an interactive R session...
if(interactive()){
# build ASEM up to results
ASEM <- build_ASEM()
# launch results dashboard
resultsDash(ASEM)
}

}
\seealso{
\itemize{
\item \code{\link[=indDash]{indDash()}} shiny dashboard for exploring indicator distributions
\item \code{\link[=rew8r]{rew8r()}} shiny dashboard for altering weights and visualising correlations
}
}
