% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_rew8r.R
\name{corrweightscat}
\alias{corrweightscat}
\title{Scatter plot of correlations against weights}
\usage{
corrweightscat(
  dat,
  facet = FALSE,
  acvar = NULL,
  linesw = FALSE,
  locorval = NULL,
  hicorval = NULL
)
}
\arguments{
\item{dat}{Data frame with first col indicator codes, second is weights, third is correlations}

\item{facet}{Logical: if \code{TRUE} creates subplots.}

\item{acvar}{Active variable to highlight (one of the indicator codes)}

\item{linesw}{Whether to plot a vertical line showing low correlation boundary}

\item{locorval}{x value of low correlation line}

\item{hicorval}{x value of high correlation line}
}
\value{
A scatter plot generated using plotly, also outputs event data (the clicked indicator).
}
\description{
Plots correlations on the x axis and weights on the y axis. Allows a selected highlighted point
and a line showing low correlation boundary. This function is intended for use inside \code{\link[=rew8r]{rew8r()}}.
}
\details{
Since this plot is really only intended for use inside \code{\link[=rew8r]{rew8r()}} no example is provided.
}
\seealso{
\itemize{
\item \code{\link[=rew8r]{rew8r()}} Interactive app for adjusting weights and seeing effects on correlations
\item \code{\link[=getCorr]{getCorr()}} Get correlations between indicators/levels
}
}
