% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_multivariate.R
\name{plotCorr}
\alias{plotCorr}
\title{Static heatmaps of correlation matrices}
\usage{
plotCorr(
  COIN,
  dset = "Raw",
  icodes = NULL,
  aglevs = 1,
  cortype = "pearson",
  withparent = "parent",
  grouplev = NULL,
  showvals = TRUE,
  flagcolours = FALSE,
  flagthresh = c(-0.4, 0.3, 0.9),
  pval = 0.05,
  out2 = "fig"
)
}
\arguments{
\item{COIN}{The COIN object}

\item{dset}{The target data set.}

\item{icodes}{An optional list of character vectors where the first entry specifies the indicator/aggregate
codes to correlate against the second entry (also a specification of indicator/aggregate codes)}

\item{aglevs}{The aggregation levels to take the two groups of indicators from. See \code{\link[=getIn]{getIn()}} for details.}

\item{cortype}{The type of correlation to calculate, either \code{"pearson"}, \code{"spearman"}, or \code{"kendall"} (see \code{\link[stats:cor]{stats::cor()}}).}

\item{withparent}{If \code{aglev[1] != aglev[2]}, and equal \code{"parent"} will only plot correlations of each row with its parent (default).
If \code{"family"}, plots the lowest aggregation level in \code{aglevs} against all its parent levels.
If \code{"none"} plots the full correlation matrix.}

\item{grouplev}{The aggregation level to group correlations by if \code{aglev[1] == aglev[2]}. By default, groups correlations into the
aggregation level above. Set to 0 to disable grouping and plot the full matrix.}

\item{showvals}{If \code{TRUE}, shows correlation values. If \code{FALSE}, no values shown.}

\item{flagcolours}{If \code{TRUE}, uses discrete colour map with thresholds defined by \code{flagthresh}. If \code{FALSE} uses continuous colour map.}

\item{flagthresh}{A 3-length vector of thresholds for highlighting correlations, if \code{flagcolours = TRUE}.
\code{flagthresh[1]} is the negative threshold. Below this value, values will be flagged red.
\code{flagthresh[2]} is the "weak" threshold. Values between \code{flagthresh[1]} and \code{flagthresh[2]} are coloured grey.
\code{flagthresh[3]} is the "high" threshold. Anything between \code{flagthresh[2]} and \code{flagthresh[3]} is flagged "OK",
and anything above \code{flagthresh[3]} is flagged "high".}

\item{pval}{The significance level for plotting correlations. Correlations with \eqn{p < pval} will be shown,
otherwise they will be plotted as white squares. Set to 0 to disable this.}

\item{out2}{If \code{"fig"} returns a plot, if \code{"dflong"} returns the correlation matrix in long form, if \code{"dfwide"},
returns the correlation matrix in wide form. The last option here is probably useful if you want to
present a table of the data in a report.}
}
\value{
If \code{out2 = "fig"} returns a plot generated with \strong{ggplot2}. These can be edited further with \strong{ggplot2} commands.
If \code{out2 = "dflong"} returns the correlation matrix as a data frame in long form, if \code{out2 = "dfwide"},
returns the correlation matrix in wide form. The last option here is probably useful if you want to
present a table of the data in a report.
}
\description{
Generates heatmaps of correlation matrices using \strong{ggplot2}. This enables correlating any set of indicators against any other,
and supports calling named aggregation groups of indicators. The \code{withparent} argument generates tables of correlations only with
parents of each indicator. Also supports discrete colour maps using \code{flagcolours}, different types of correlation, and groups
plots by higher aggregation levels.
}
\details{
This function calls \code{\link[=getCorr]{getCorr()}}.

Note that this function can only call correlations within the same data set (i.e. only one data set in \code{.$Data}).
}
\examples{
# build ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# correlation data frame of indicators in connectivity sub-index, grouped by pillar
corrs <- plotCorr(ASEM, dset = "Raw", icodes = "Conn", aglevs = 1,
showvals = F, out2 = "dflong")
# NOTE to create a plot instead set out2 = "fig"

}
\seealso{
\itemize{
\item \code{\link[=getCorr]{getCorr()}} Getting correlation matrices of indicator subsets
}
}
