% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_aggregate.R
\name{harMean}
\alias{harMean}
\title{Weighted harmonic mean}
\usage{
harMean(x, w = NULL)
}
\arguments{
\item{x}{A numeric vector of positive values.}

\item{w}{A vector of weights, which should have length equal to \code{length(x)}. Weights are relative
and will be re-scaled to sum to 1. If \code{w} is not specified, defaults to equal weights.}
}
\value{
Weighted harmonic mean, as a numeric value.
}
\description{
Weighted harmonic mean of a vector. \code{NA} are skipped by default. This function is used inside
\code{\link[=aggregate]{aggregate()}}.
}
\examples{
# a vector of values
x <- 1:10
# a vector of weights
w <- runif(10)
# weighted harmonic mean
harMean(x,w)

}
