% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_treat.R
\name{coin_win}
\alias{coin_win}
\title{Winsorisation helper function}
\usage{
coin_win(
  icol,
  winmax,
  winchange = TRUE,
  t_skew = 2,
  t_kurt = 3.5,
  icode = NULL
)
}
\arguments{
\item{icol}{The vector of data to Winsorise}

\item{winmax}{The maximum number of points to Winsorise for each indicator. If \code{NA}, will keep Winsorising until skewness and kurtosis
thresholds achieved (but it is likely this will cause errors).}

\item{winchange}{Logical: if \code{TRUE}, Winsorisation can change direction from one iteration to the next. Otherwise if \code{FALSE} (default), no change.}

\item{t_skew}{Absolute skew threshold (default 2).}

\item{t_kurt}{Kurtosis threshold (default 3.5).}

\item{icode}{The indicator name - used for error messages in \code{\link[=treat]{treat()}}.}
}
\value{
A list containing:
\itemize{
\item \code{.$icol} the vector of treated data
\item \code{.$imax} the indices of elements of the vector that were Winsorised as high values
\item \code{.$imax} the indices of elements of the vector that were Winsorised as low values
\item \code{.$winz} the total number of Winsorised points
}
}
\description{
To be used inside \code{\link[=treat]{treat()}} to avoid repetitions. Winsorises a numerical vector of data.
}
\details{
Outliers are identified according to skewness and kurtosis thresholds. The algorithm attempts to reduce the absolute skew and
kurtosis by successively Winsorising points up to a specified limit.

The process is detailed in the \href{https://bluefoxr.github.io/COINrDoc/data-treatment.html#data-treatment-in-coinr}{COINr online documentation}.
}
\examples{
# get a column of data with outliers
x <- ASEMIndData$Tariff
# Winsorise up to five points
winlist <- coin_win(x, winmax = 5)
# check the differences
data.frame(
Orig = x,
Treated = winlist$icol,
Changes = ifelse(x == winlist$icol, "Same", "Treated"))

}
\seealso{
\itemize{
\item \code{\link[=treat]{treat()}} Outlier treatment
}
}
