% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/underscored_pos_to_GRanges.R
\name{underscored_pos_to_GRanges}
\alias{underscored_pos_to_GRanges}
\title{Convert coordinates in underscored format to a GRanges object.}
\usage{
underscored_pos_to_GRanges(underscored_positions = NULL,
  extended_data = NULL, zeroToOneBasedStart = T,
  zeroToOneBasedEnd = F)
}
\arguments{
\item{underscored_positions}{A vector of positions of the form c("chr1_0_5000","chr1_7500_10000","chr1_10000_15000")}

\item{extended_data}{Optional metadata columns. These columns cannot be named "start", "end", "width", or "element". Passed to GRanges object as ...}

\item{zeroToOneBasedStart}{Converts a set of underscored positions that begin with zero to GRanges where the lowest positional value on a chromosome is 1. Essentially adds 1 to start}

\item{zeroToOneBasedEnd}{Adds 1 to the end of the underscored positions}
}
\value{
A GRanges object
}
\description{
This function creates a new GRanges object from a character vector of coordinates in the form "chr1_0_5000" and creates a GRanges object from them.
}
\examples{
load(system.file("extdata","nbl_result_matrix_sign_small.rda",package = "CNVScope"))
underscored_pos_to_GRanges(colnames(nbl_result_matrix_sign_small))
}
\keyword{CNV}
\keyword{GRanges}
\keyword{Genomic}
\keyword{Ranges}
\keyword{position}
