% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_future_hv_poles.R
\name{pof_future_poles}
\alias{pof_future_poles}
\title{Future Probability of Failure for Poles}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
pof_future_poles(
  pole_asset_category = "20kV Poles",
  sub_division = "Wood",
  placement = "Default",
  altitude_m = "Default",
  distance_from_coast_km = "Default",
  corrosion_category_index = "Default",
  age,
  pole_decay = "default",
  observed_condition_inputs,
  reliability_factor = "Default",
  simulation_end_year = 100
)
}
\arguments{
\item{pole_asset_category}{String The type of asset category}

\item{sub_division}{String. Refers to material the pole is made of.}

\item{placement}{String. Specify if the asset is located outdoor or indoor.}

\item{altitude_m}{Numeric. Specify the altitude location for
the asset measured in meters from sea level.\code{altitude_m}
is used to derive the altitude factor. See page 111,
table 23 in CNAIM (2021). A setting of \code{"Default"}
will set the altitude factor to 1 independent of \code{asset_type}.}

\item{distance_from_coast_km}{Numeric. Specify the distance from the
coast measured in kilometers. \code{distance_from_coast_km} is used
to derive the distance from coast factor See page 110,
table 22 in CNAIM (2021). A setting of \code{"Default"} will set the
 distance from coast factor to 1 independent of \code{asset_type}.}

\item{corrosion_category_index}{Integer.
Specify the corrosion index category, 1-5.}

\item{age}{Numeric. The current age in years of the conductor.}

\item{pole_decay}{Numeric Pole Decay}

\item{observed_condition_inputs}{Named list observed_conditions_input
\code{conductor_samp = c("Low","Medium/Normal","High","Default")}.
See page 161, table 199 and 201 in CNAIM (2021).}

\item{reliability_factor}{Numeric. \code{reliability_factor}
shall have a value between 0.6 and 1.5. A setting of \code{"Default"}
 sets the \code{reliability_factor} to 1.
See section 6.14 on page 73 in CNAIM (2021).}

\item{simulation_end_year}{Numeric. The last year of simulating probability
of failure. Default is 100.}
}
\value{
Numeric array. Future probability of failure
per annum per kilometre for poles.
}
\description{
This function calculates the future
annual probability of failure per kilometer for a poles.
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function. For more information about the
probability of failure function see section 6
on page 34 in CNAIM (2021).
}
\examples{
# Future annual probability of failure for HV Poles
pof_future_poles(
pole_asset_category = "20kV Poles",
sub_division = "Wood",
placement = "Default",
altitude_m = "Default",
distance_from_coast_km = "Default",
corrosion_category_index = "Default",
age = 10,
observed_condition_inputs =
list("visual_pole_cond" =
list("Condition Criteria: Pole Top Rot Present?" = "Default"),
"pole_leaning" = list("Condition Criteria: Pole Leaning?" = "Default"),
"bird_animal_damage" =
list("Condition Criteria: Bird/Animal Damage?" = "Default"),
"top_rot"  = list("Condition Criteria: Pole Top Rot Present?" = "Default")),
pole_decay = "Default",
reliability_factor = "Default",
simulation_end_year = 100)
}
