% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.data_engineering.R
\name{get.CME.UI.data}
\alias{get.CME.UI.data}
\title{Return different format of the final aggregate results country summary}
\usage{
get.CME.UI.data(
  dir_file = NULL,
  c_iso = NULL,
  year_range = c(1990:2019),
  get = "both",
  idvars = c("OfficialName", "ISO3Code"),
  sex = NULL,
  format = "long",
  round_digit = 1L,
  use_IGME_year = 2020,
  quantile = TRUE
)
}
\arguments{
\item{dir_file}{allow a different dataset to be read: directory to aggregate
final}

\item{c_iso}{country iso, if NULL, returns all isos, default to NULL}

\item{year_range}{a vector of years, default to 1990: 2019}

\item{get}{default to "rate". Choose among "rate", "death", or "both"}

\item{idvars}{default to "`OfficialName`, `ISO3Code`", what id vars you want
to include}

\item{sex}{Sex column value: Total, Female or Male, if left as NULL as
default will be determined from directory of `dir_file`}

\item{format}{Choose format among raw, long, wide_year, wide_ind, and
wide_get, default to "long". All the wide-format just `dcasts` the
long-format data, wide_get means two columns: rate and death}

\item{round_digit}{digits to round estimates, default to 1}

\item{use_IGME_year}{load the saved IGME final aggregated results (final):
2019 or 2020}

\item{quantile}{TRUE: return upper, median, lower; FALSE: only median}
}
\value{
a data.table
}
\description{
`get.CME.UI.data` can read in "Rates & Deaths_Country Summary.csv" for any
indicators published so far and include Sex, Quantile in the output. A
pre-saved list of summary.csv files directories could be obtained by
\code{\link{load.final_dir}}. Output dataset in either long, wide year, wide
indicator, or wide `get` (one column for rate and one column for death)
}
\examples{
dt_1 <- get.CME.UI.data(use_IGME_year = 2020, format = "wide_year")
dt_2 <- get.CME.UI.data(format = "wide_ind")


}
