% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ggomnbd_expectation}
\alias{ggomnbd_expectation}
\alias{ggomnbd_nocov_expectation}
\alias{ggomnbd_staticcov_expectation}
\title{GGompertz/NBD: Unconditional Expectation}
\usage{
ggomnbd_nocov_expectation(r, alpha_0, b, s, beta_0, vT_i)

ggomnbd_staticcov_expectation(r, b, s, vAlpha_i, vBeta_i, vT_i)
}
\arguments{
\item{r}{shape parameter of the Gamma distribution of the purchase process.
The smaller r, the stronger the heterogeneity of the purchase process.}

\item{alpha_0}{scale parameter of the Gamma distribution of the purchase process.}

\item{b}{scale parameter of the Gompertz distribution (constant across customers)}

\item{s}{shape parameter of the Gamma distribution for the lifetime process
The smaller s, the stronger the heterogeneity of customer lifetimes.}

\item{beta_0}{scale parameter for the Gamma distribution for the lifetime process}

\item{vT_i}{Number of periods since the customer came alive}

\item{vAlpha_i}{Vector of individual parameters alpha}

\item{vBeta_i}{Vector of individual parameters beta}
}
\value{
Returns the expected transaction values according to the chosen model.
}
\description{
Computes the expected number of repeat transactions in the interval (0, vT_i]
for a randomly selected customer, where 0 is defined as the point when the customer came alive.
}
\references{
Bemmaor AC, Glady N (2012). \dQuote{Modeling Purchasing Behavior with Sudden \dQuote{Death}: A Flexible Customer
Lifetime Model} Management Science, 58(5), 1012-1021.
}
