% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_clv_data_dynamiccovariates.R,
%   R/f_s3generics_clvdata_dynamiccov.R
\docType{class}
\name{clv.data.dynamic.covariates-class}
\alias{clv.data.dynamic.covariates-class}
\alias{show,clv.data.dynamic.covariates-method}
\title{Transactional and dynamic covariates data to fit CLV models}
\usage{
\S4method{show}{clv.data.dynamic.covariates}(object)
}
\description{
Extends the class \code{\link[CLVTools:clv.data.static.covariates-class]{clv.data.static.covariates}},
but adds no additional slots to it. The purpose of this class rather is to define different behaviors
suitable for dynamic covariates.

The \code{data.table}s stored in the slots \code{data.cov.life} and \code{data.cov.trans}
each contain an additional column \code{Cov.Date} for the timepoint of the covariate.

An object of this class serves as input to fit models with dynamic covariates.
}
\section{Slots}{

\describe{
\item{\code{data.cov.life}}{Single \code{data.table} with all static covariate data for the lifetime process}

\item{\code{data.cov.trans}}{Single \code{data.table} with all static covariate data for the transaction process}

\item{\code{names.cov.data.life}}{Character vector with names of the dynamic lifetime covariates.}

\item{\code{names.cov.data.trans}}{Character vector with names of the dynamic transaction covariates.}
}}

\seealso{
Definition of the parent class \code{\link[CLVTools:clv.data.static.covariates-class]{clv.data.static.covariates}}.

For fitting dynamic covariate models: \code{\link[CLVTools:pnbd]{pnbd}}
}
\keyword{internal}
