% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lbsFindDuplicateAuthors}
\alias{lbsFindDuplicateAuthors}
\title{Find groups of authors to be merged (**EXPERIMENTAL**)}
\usage{
lbsFindDuplicateAuthors(conn, names.like = NULL, ignoreWords = c("van",
  "von", "der", "no", "author", "name", "available"), minWordLength = 4,
  orderResultsBy = c("citations", "ndocuments", "name"), aggressiveness = 0)
}
\arguments{
\item{conn}{connection object, see \code{\link{lbsConnect}}.}

\item{names.like}{character vector of SQL-LIKE patterns that allow for restricting
the search procedure to only given authors' names.}

\item{ignoreWords}{character vector; words to be ignored.}

\item{minWordLength}{numeric; minimal word length to be considered.}

\item{orderResultsBy}{determines results' presentation order; one of
\code{citations}, \code{ndocuments} \code{name}.}

\item{aggressiveness}{nonnegative integer; controls the search depth.}
}
\value{
List of authors' identifiers to be merged.
The first element of each vector is the one marked by the user as \emph{Parent},
and the rest are the \emph{Children}.
}
\description{
Indicates, by finding similarities between authors' names,
groups of authors that possibly should be merged.
}
\details{
The function uses a heuristic **EXPERIMENTAL** algorithm. Its behavior
is controlled by the \code{aggressiveness} parameter.

Search results are presented in a convenient-to-use graphical dialog box.
Note that the calculation often takes a few minutes!

The \code{names.like} parameter determines search patterns in an SQL \code{LIKE} format,
i.e. an underscore \code{_} matches a single character and a percent sign
\code{\%} matches any set of characters. The search is case-insensitive.
}
\examples{
\dontrun{
conn <- lbsConnect("Bibliometrics.db");
## ...
listauth <- lbsFindDuplicateAuthors(conn,
   ignoreWords=c("van", "von", "der", "no", "author", "name", "available"),
   minWordLength=4,
   orderResultsBy=c("citations"),
   aggressiveness=1);
lbsMergeAuthors(conn, listauth);
dbCommit(conn);
## ...}
}
\seealso{
\code{\link{lbsMergeAuthors}}, \code{\link{lbsFindDuplicateTitles}}, \code{\link{lbsGetInfoAuthors}}
}

