% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGRAF2.R
\name{MGRAF2}
\alias{MGRAF2}
\title{Second variant of M-GRAF model}
\usage{
MGRAF2(A, K, tol, maxit)
}
\arguments{
\item{A}{Binary array with size VxVxn storing the VxV symmetric adjacency
matrices of n graphs.}

\item{K}{An integer that specifies the latent dimension of the graphs}

\item{tol}{A numeric scalar that specifies the convergence threshold of CISE
algorithm. CISE iteration continues until the absolute percent change in
joint log-likelihood is smaller than this value. Default is tol = 0.01.}

\item{maxit}{An integer that specifies the maximum number of iterations.
Default is maxit = 5.}
}
\value{
A list is returned containing the ingredients below from M-GRAF2
  model corresponding to the largest log-likelihood over iterations.
  \item{Z}{A numeric vector containing the lower triangular
  entries in the estimated matrix Z.} \item{Lambda}{Kx1 vector storing the
  diagonal entries in \eqn{\Lambda}.} \item{Q}{VxKxn array containing the estimated
  VxK orthonormal matrix \eqn{Q_i}, i=1,...,n.} \item{D_LT}{Lxn matrix where
  each column stores the lower triangular entries in \eqn{D_i = Q_i * \Lambda
  * Q_i^{\top}}; L=V(V-1)/2.} \item{LL_max}{Maximum log-likelihood across
  iterations.} \item{LL}{Joint log-likelihood at each iteration.}
}
\description{
\code{MGRAF2} returns the estimated common structure Z and \eqn{\Lambda} that
are shared by all the subjects as well as the subject-specific low rank
matrix \eqn{Q_i} for multiple undirected graphs.
}
\details{
The subject-specific deviation \eqn{D_i} is decomposed into \deqn{D_i = Q_i
* \Lambda * Q_i^{\top},} where each \eqn{Q_i} is a VxK orthonormal matrix and
\eqn{\Lambda} is a KxK diagonal matrix.
}
\examples{
data(A)
n = dim(A)[3]
subs = sample.int(n=n,size=30)
A_sub = A[ , , subs]
res = MGRAF2(A=A_sub, K=3, tol=0.01, maxit=5)

}
