context("util")

test_that("unavailable elements cause errors in mass() and entropy()", {
  # the suppressWarnings here refer to the warnings generated by makeup() about the missing elements
  expect_error(suppressWarnings(mass("Xxx")), "element\\(s\\) Xxx not available in thermo\\$element")
  # 20130101: the error here was changed to a warning to restore functionality of check.obigt()
  #   (species in the database include those with Am Cm Np Pu, not listed in thermo$element)
  #expect_error(suppressWarnings(entropy("Xxx")), "element\\(s\\) Xxx not available in thermo\\$element")
})

test_that("GHS() and ZC() give warnings and errors in some situation", {
  expect_error(GHS(c("CO2","H2O"),G=0,H=0), "formula, G, H and S arguments are not same length")
  expect_error(ZC("H2O"), "carbon not found in the stoichiometric matrix")
  iATP <- info("ATP-4")
  expect_warning(ZC(iATP), "element\\(s\\) P .* not included in this calculation")
})

test_that("GHS() and obigt2eos() produce expected values", {
  ## a species with missing entropy value
  ic <- info("cystine")
  icdata <- info(ic)
  GHS <- GHS(icdata$formula, G=icdata$G, H=icdata$H, S=icdata$S)
  expect_equal(GHS[[3]], 61.8102928143)
  # done through obigt2eos
  coe <- obigt2eos(thermo$obigt[ic,], "aq", fixGHS=TRUE)
  expect_equal(coe$S, GHS[[3]])
  ## mass and entropy of elements in chemical formulas
  # the "-1" is a single negative charge, the electron
  testform <- c("CH4", "H2O", "-1")
  testmass <- mass(testform)
  testent <- entropy(testform)
  expect_equal(testmass, c(16.04276, 18.01528, 0))
  expect_equal(testent, c(63.83843212237, 55.74952198853, 15.61663479924))
  # another way to calculate the entropy of the elements in H2O
  testGHS <- GHS("H2O", G=0, H=0)
  expect_equal(as.numeric(testGHS[1, 3]), testent[2])
})
  

test_that("expr.species() produces expected errors", {
  expect_error(expr.species(c("H2O", "CO2")), "more than one species")
  expect_error(expr.species("CO2", log = "aqq"), "'aqq' is not a recognized state")
})

test_that("[P|T|E].units() do not accept invalid units", {
  expect_error(P.units("X"), "units of pressure must be either bar or MPa")
  expect_error(T.units("X"), "units of temperature must be either C or K")
  expect_error(E.units("X"), "units of energy must be either cal or J")
})

test_that("describe.property() does not accept NULL values", {
  expect_error(describe.property(), "property or value is NULL")
})

test_that("count.aa() warns about unrecognized amino acids", {
  expect_message(count.aa("ABCDEFGHIJ"), "count.aa: unrecognized amino acid code\\(s\\): B J")
})
