% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parScale.R
\docType{methods}
\name{parScale}
\alias{parScale}
\alias{parScale,Raster-method}
\title{Efficient scaling of Raster* objects}
\usage{
parScale(x, ...)

\S4method{parScale}{Raster}(x, center = TRUE, scale = TRUE, filename = "",
  quiet = TRUE, parallel = FALSE, n = 1, ...)
}
\arguments{
\item{x}{Raster* object}

\item{...}{Additional arguments for \code{\link[raster]{writeRaster}}}

\item{center}{logical or numeric. If \code{TRUE}, centering is done by
subtracting the layer means (omitting NAs), and if \code{FALSE}, no centering
is done. If \code{center} is a numeric vector with length equal to the
\code{nlayers(x)}, then each layer of \code{x} has the corresponding value
from center subtracted from it}

\item{scale}{logical or numeric. If \code{TRUE}, scaling is done by dividing
the (centered) layers of \code{x} by their standard deviations if center is
\code{TRUE}, and the root mean square otherwise. If scale is \code{FALSE},
no scaling is done. If scale is a numeric vector with length equal to
\code{nlayers(x)}, each layer of \code{x} is divided by the corresponding
value. Scaling is done after centering}

\item{filename}{character. Optional filename to save the Raster* output to
file. If this is not provided, a temporary file will be created for large \code{x}}

\item{quiet}{logical. If \code{TRUE}, messages and progress bar will be
suppressed}

\item{parallel}{logical. If \code{TRUE} then multiple cores are utilized}

\item{n}{numeric. Number of CPU cores to utilize for parallel processing}
}
\value{
Raster* object
}
\description{
\code{parScale} expands the \code{raster::scale} function to allow for
faster parallel processing, scaling each layer of \code{x} in parallel.
}
\examples{
ch.scale <- parScale(x = climdat.hist)

}
\seealso{
\code{\link[base]{scale}}, \code{\link[raster]{scale}}
}
