% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimEA.R
\name{selfAdapt}
\alias{selfAdapt}
\title{Self-adaption of EA parameters.}
\usage{
selfAdapt(
  params,
  inum,
  icat,
  iint,
  nnum,
  ncat,
  nint,
  lower,
  upper,
  values,
  nvalues,
  tau,
  p
)
}
\arguments{
\item{params}{parameters to be self-adapted}

\item{inum}{boolean vector, which parameters are numeric}

\item{icat}{boolean vector, which parameters are discrete, factors}

\item{iint}{boolean vector, which parameters are integer}

\item{nnum}{number of numerical parameters}

\item{ncat}{number of discrete parameters}

\item{nint}{number of integer parameters}

\item{lower}{lower bounds (numeric, integer parameters only)}

\item{upper}{upper bounds (numeric, integer parameters only)}

\item{values}{values or levels of the discrete parameters}

\item{nvalues}{number of values for each discrete parameter}
}
\description{
Learning / self-adaption of parameters of the evolutionary algorithm.
}
\seealso{
\code{\link{optimEA}}
}
\keyword{internal}
