% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SearchCatalogBy.R
\name{SearchCatalogBy...}
\alias{SearchCatalogBy...}
\alias{SearchCatalogByTimerange}
\alias{SearchCatalogByAOI}
\alias{SearchCatalogByBbox}
\title{Search collection for available images (vectorization ready)}
\source{
\url{https://documentation.dataspace.copernicus.eu/APIs/SentinelHub/Catalog.html}
}
\usage{
SearchCatalogByTimerange(
  time_range,
  aoi,
  bbox,
  collection,
  as_data_frame = TRUE,
  with_geometry = TRUE,
  filter = NULL,
  client,
  token,
  url = getOption("CDSE.catalog_url")
)

SearchCatalogByAOI(
  aoi,
  time_range,
  collection,
  as_data_frame = TRUE,
  with_geometry = TRUE,
  filter = NULL,
  client,
  token,
  url = getOption("CDSE.catalog_url")
)

SearchCatalogByBbox(
  bbox,
  time_range,
  collection,
  as_data_frame = TRUE,
  with_geometry = TRUE,
  filter = NULL,
  client,
  token,
  url = getOption("CDSE.catalog_url")
)
}
\arguments{
\item{time_range}{scalar or vector (Date or character that can be converted to date) defining the time interval.
Open interval (one side only) can be obtained by providing the \code{NA} or \code{NULL} value for the corresponding argument.}

\item{aoi}{sf or sfc object, typically a (multi)polygon, describing the Area of Interest.}

\item{bbox}{numeric vector of four elements describing the bounding box of interest.
    Specify with a coordinate pair on two (opposite) vertices of the bounding box rectangle.
    Coordinates need to be in longitude, latitude.

Only one of either \code{aoi} or \code{bbox} may be specified.}

\item{collection}{character indicating which collection to search.
Must be one of the collections returned by \code{GetCollections}.}

\item{as_data_frame}{logical indicating if the result should be returned as data frame. Default: TRUE}

\item{with_geometry}{logical indicating if the granule geometries should be included in the data.frame. Default: TRUE}

\item{filter}{character, CQL2 text filter. Use the function \code{GetQueryables} to find out which filters
can bu used with the collection. Default: NULL (no filtering)}

\item{client}{OAuth client object to use for authentication.}

\item{token}{OAuth token character string to use for authentication.

Exactly one of either \code{client} or \code{token} must be specified. It is recommended to use \code{client}.}

\item{url}{character indicating the STAC catalog search endpoint. Default: Copernicus Data Space Ecosystem STAC endpoint}
}
\value{
A \code{list}, \code{data.frame} or a \code{sf} object.
}
\description{
These functions search the specified collection for available images using the parameters provided.
    They are simple wrappers around the 'SearchCatalog' function with arguments organized in a way
    that facilitates calling the function in a vectorized manner (using 'lapply' or similar function)
    and thus potentially also the parallelization. The 'from' and 'to' arguments are combined into a single argument 'time_range'.
}
\details{
If no images found, a \code{NULL} value is returned.

\code{SearchCatalogByTimerange} is arranged for vectorization on time_range (time_range is the first argument).

\code{SearchCatalogByAOI} is arranged for vectorization on aoi (aoi is the first argument).

\code{SearchCatalogByBbox} is arranged for vectorization on bbox (bbox is the first argument).
}
\examples{
\dontrun{
dsn <- system.file("extdata", "centralpark.geojson", package = "CDSE")
aoi <- sf::read_sf(dsn, as_tibble = FALSE)
seasons <- SeasonalTimerange(from = "2020-06-01", to = "2023-08-31")
lst_images_cloudless <- lapply(seasons, SearchCatalogByTimerange, aoi = aoi,
    collection = "sentinel-2-l2a", with_geometry = FALSE,
    filter = "eo:cloud_cover < 5", client = OAuthClient)
images_cloudless <- do.call(rbind, lst_images_cloudless)
images_cloudless <- images_cloudless[rev(order(images_cloudless$acquisitionDate)), ]
row.names(images_cloudless) <- NULL
head(images_cloudless[, 1:5])
}
}
\seealso{
\code{\link[CDSE]{SearchCatalog}}
}
