% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SearchCatalog.R
\name{SearchCatalog}
\alias{SearchCatalog}
\title{Search collection for available images}
\source{
\url{https://documentation.dataspace.copernicus.eu/APIs/SentinelHub/Catalog.html}
}
\usage{
SearchCatalog(
  aoi,
  bbox,
  from,
  to,
  collection,
  as_data_frame = TRUE,
  with_geometry = TRUE,
  filter = NULL,
  client,
  token,
  url = getOption("CDSE.catalog_url")
)
}
\arguments{
\item{aoi}{sf or sfc object, typically a (multi)polygon, describing the Area of Interest.}

\item{bbox}{numeric vector of four elements describing the bounding box of interest.
    Specify with a coordinate pair on two (opposite) vertices of the bounding box rectangle.
    Coordinates need to be in longitude, latitude.

Only one of either \code{aoi} or \code{bbox} may be specified.}

\item{from}{start of the time interval to search.}

\item{to}{end of the time interval to search.

\code{from} and \code{to} can be either Date or character that can be converted to date by \code{as.Date}.

Open interval (one side only) can be obtained by providing the \code{NA} or \code{NULL} value for the corresponding argument.}

\item{collection}{character indicating which collection to search.
Must be one of the collections returned by \code{GetCollections}.}

\item{as_data_frame}{logical indicating if the result should be returned as data frame. Default: TRUE}

\item{with_geometry}{logical indicating if the granule geometries should be included in the data.frame. Default: TRUE}

\item{filter}{character, CQL2 text filter. Use the function \code{GetQueryables} to find out which filters
can bu used with the collection. Default: NULL (no filtering)}

\item{client}{OAuth client object to use for authentication.}

\item{token}{OAuth token character string to use for authentication.

Exactly one of either \code{client} or \code{token} must be specified. It is recommended to use \code{client}.}

\item{url}{character indicating the STAC catalog search endpoint. Default: Copernicus Data Space Ecosystem STAC endpoint}
}
\value{
A \code{list}, \code{data.frame} or a \code{sf} object.
}
\description{
Searches the specified collection for available images in the given time interval and intersecting with the
    bounding box or the area of interest.
}
\details{
If no images found, a \code{NULL} value is returned.
}
\examples{
\dontrun{
dsn <- system.file("extdata", "luxembourg.geojson", package = "CDSE")
aoi <- sf::read_sf(dsn, as_tibble = FALSE)
images <- SearchCatalog(aoi = aoi, from = "2023-07-01", to = "2023-07-31",
          collection = "sentinel-2-l2a", with_geometry = TRUE, client = OAuthClient)
images_cloudless <- SearchCatalog(aoi = aoi, from = "2023-07-01", to = "2023-07-31",
          filter = "eo:cloud_cover < 5",
          collection = "sentinel-2-l2a", with_geometry = TRUE, client = OAuthClient)
}
}
\seealso{
\code{\link[CDSE]{GetCollections}}, \code{\link[CDSE]{GetQueryables}}, \code{\link[CDSE]{GetImage}}
}
