% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePermanent.R
\name{computePermanent}
\alias{computePermanent}
\title{Run a dplyr query and store the result in a permanent table}
\usage{
computePermanent(x, name, schema = NULL, overwrite = FALSE)
}
\arguments{
\item{x}{A dplyr query}

\item{name}{Name of the table to be created}

\item{schema}{Schema to create the new table in
Can be a length 1 or 2 vector. (e.g. schema = "my_schema", schema = c("my_schema", "dbo))}

\item{overwrite}{If the table already exists in the remote database should it be overwritten? (TRUE or FALSE)}
}
\value{
A dplyr reference to the newly created table
}
\description{
Run a dplyr query and store the result in a permanent table
}
\examples{
\dontrun{
library(CDMConnector)
library(SqlUtilities)

con <- DBI::dbConnect(duckdb::duckdb(), dbdir = CDMConnector::eunomia_dir())
concept <- dplyr::tbl(con, "concept")

rxnorm_count <- concept \%>\%
  dplyr::filter(domain_id == "Drug") \%>\%
  dplyr::mutate(isRxnorm = (vocabulary_id == "RxNorm")) \%>\%
  dplyr::count(isRxnorm) \%>\%
  computePermanent("rxnorm_count")

DBI::dbDisconnect(con, shutdown = TRUE)
}
}
