% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.cvxclust}
\alias{plot.cvxclust}
\title{Plot 2D clusterpath}
\usage{
\method{plot}{cvxclust}(x, col = NULL, labels = NULL, ...)
}
\arguments{
\item{x}{A \code{cvxclust} object.}

\item{col}{A vector containing cluster membership information. Default is
\code{NULL}.}

\item{labels}{A vector containing labels for each object. Default is
\code{NULL}.}

\item{...}{Further graphical parameters.}
}
\value{
A plot in the console.
}
\description{
Plot a clusterpath for two-dimensional data.
}
\examples{
# Load data
data(two_half_moons)
data = as.matrix(two_half_moons)
X = data[, -3]
y = data[, 3]

# Get sparse distances in dictionary of keys format with k = 5 and phi = 8
W = sparse_weights(X, 5, 8.0)

# Set a sequence for lambda
lambdas = seq(0, 2400, 1)

# Compute results CMM
res = convex_clusterpath(X, W, lambdas)
plot(res, y + 1)

}
