% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_MPAs}
\alias{load_MPAs}
\title{Load CCAMLR Marine Protected Areas}
\usage{
load_MPAs()
}
\description{
Download the up-to-date spatial layer from the online CCAMLRGIS (\url{http://gis.ccamlr.org/}) and load it to your environment.
See examples for offline use. All layers use the Lambert azimuthal equal-area projection
 (\code{\link{CCAMLRp}})
}
\examples{
 
\donttest{

#When online:
MPAs=load_MPAs()
plot(st_geometry(MPAs))

#For offline use, see:
#https://github.com/ccamlr/CCAMLRGIS#32-offline-use

}

}
\seealso{
\code{\link{load_ASDs}}, \code{\link{load_SSRUs}}, \code{\link{load_RBs}},
\code{\link{load_SSMUs}}, \code{\link{load_MAs}}, \code{\link{load_Coastline}},
\code{\link{load_EEZs}}.
}
