% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_Lines}
\alias{create_Lines}
\title{Create Lines}
\usage{
create_Lines(
  Input,
  NamesIn = NULL,
  Buffer = 0,
  Densify = FALSE,
  Clip = FALSE,
  SeparateBuf = TRUE
)
}
\arguments{
\item{Input}{input dataframe.

\strong{If \code{NamesIn} is not provided, the columns in the \code{Input} must be in the following order:

Line name, Latitude, Longitude.

If a given line is made of more than two points, the locations of points
must be given in order, from one end of the line to the other.}}

\item{NamesIn}{character vector of length 3 specifying the column names of line identifier, Latitude
and Longitude fields in the \code{Input}.

\strong{Names must be given in that order, e.g.:

\code{NamesIn=c('Line ID','Line Latitudes','Line Longitudes')}}.}

\item{Buffer}{numeric, distance in nautical miles by which to expand the lines. Can be specified for
each line (as a numeric vector).}

\item{Densify}{logical, if set to TRUE, additional points between points of equal latitude are added
prior to projection (see examples).}

\item{Clip}{logical, if set to TRUE, polygon parts (from buffered lines) that fall on land are removed (see \link{Clip2Coast}).}

\item{SeparateBuf}{logical, if set to FALSE when adding a \code{Buffer},
all spatial objects are merged, resulting in a single spatial object.}
}
\value{
Spatial object in your environment.
Data within the resulting spatial object contains the data provided in the \code{Input} plus
additional "LengthKm" and "LengthNm" columns which corresponds to the lines lengths,
in kilometers and nautical miles respectively. If additional data was included in the \code{Input},
any numerical values are summarized for each line (min, max, mean, median, sum, count and sd).

To see the data contained in your spatial object, type: \code{View(MyLines)}.
}
\description{
Create lines to display, for example, fishing line locations or tagging data.
}
\examples{
\donttest{


#If your data contains line end locations in separate columns, you may reformat it as follows:

#Example data:
MyData=data.frame(
  Line=c(1,2),
  Lat_Start=c(-60,-65),
  Lon_Start=c(-10,5),
  Lat_End=c(-61,-66),
  Lon_End=c(-2,2)
)

#Reformat to us as input as:
Input=data.frame(
  Line=c(MyData$Line,MyData$Line),
  Lat=c(MyData$Lat_Start,MyData$Lat_End),
  Lon=c(MyData$Lon_Start,MyData$Lon_End)
)

#Create lines and plot them
plot(st_geometry(create_Lines(Input=Input)))


#Example 1: Simple and non-densified lines

MyLines=create_Lines(Input=LineData)
plot(st_geometry(MyLines),lwd=2,col=rainbow(nrow(MyLines)),main="Example 1")

#Example 2: Simple and densified lines (note the curvature of the purple line)

MyLines=create_Lines(Input=LineData,Densify=TRUE)
plot(st_geometry(MyLines),lwd=2,col=rainbow(nrow(MyLines)),main="Example 2")

#Example 3: Densified, buffered and clipped lines

MyLines=create_Lines(Input=LineData,Densify=TRUE,Buffer=c(10,40,50,80,100),Clip=TRUE)

plot(st_geometry(MyLines),lwd=2,col=rainbow(nrow(MyLines)),main="Example 3")
plot(st_geometry(Coast[Coast$ID=='All',]),col='grey',add=TRUE)

#Example 4: Buffered and grouped lines
MyLines=create_Lines(Input=LineData,Densify=TRUE,Buffer=30,SeparateBuf=FALSE)
plot(st_geometry(MyLines),lwd=2,border='blue',main="Example 4")

}

}
\seealso{
\code{\link{create_Points}}, \code{\link{create_Polys}}, \code{\link{create_PolyGrids}},
\code{\link{create_Stations}}, \code{\link{create_Pies}}.
}
