% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_validation.R
\name{global_validation}
\alias{global_validation}
\title{Evaluate 'global' cross-validation}
\usage{
global_validation(model)
}
\arguments{
\item{model}{an object of class \code{\link{train}}}
}
\value{
regression (\code{\link{postResample}}) or classification  (\code{\link{confusionMatrix}}) statistics
}
\description{
Calculate validation metric using all held back predictions at once
}
\details{
Relevant when folds are not representative for the entire area of interest.
In this case, metrics like R2 are not meaningful since it doesn't reflect the general ability of
the model to explain the entire gradient of the response.
Comparable to LOOCV, predictions from all held back folds are used here together to calculate validation statistics.
}
\examples{
library(caret)
data(cookfarm)
dat <- cookfarm[sample(1:nrow(cookfarm),500),]
indices <- CreateSpacetimeFolds(dat,"SOURCEID","Date")
ctrl <- caret::trainControl(method="cv",index = indices$index,savePredictions="final")
model <- caret::train(dat[,c("DEM","TWI","BLD")],dat$VW, method="rf", trControl=ctrl, ntree=10)
global_validation(model)
}
\seealso{
\code{\link{CreateSpacetimeFolds}}
}
\author{
Hanna Meyer
}
