% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions_rsq.R
\name{get_probabilities}
\alias{get_probabilities}
\title{Probabilities for multinomial regression}
\usage{
get_probabilities(trset,testset,outc,mode,Rsq,p,n_tr)
}
\arguments{
\item{trset}{values of predictors on the training set}

\item{testset}{values of predictors on the test set}

\item{outc}{values of outcomes on the training set}

\item{mode}{\code{'binary'} (logistic regression) or \code{'multin'} (multinomial regression)}

\item{Rsq}{whether R-squared statistics constrained is introduced}

\item{p}{weight of the model}

\item{n_tr}{size of the training set}
}
\value{
Probabilities of the outcomes. In \code{'binary'} mode returns an array of the size of the number of observations in a testset. In \code{'multin'} returns an M x N matrix where M is the size of the number of observations in a testset
and N is the number of unique outcomes minus 1.
}
\description{
Function which computes probabilities of outcomes on the test set by applying regression parameters inferred by a run on the training set. Works for logistic or multinomial regression
}
\details{
In binary mode this function computes the probabilities of the event '0'. In multinomial mode computes the probabilities of the events '0','1',...,'N-1'.
}
\examples{
trset<-matrix(c(rbinom(70,1,0.5),runif(70,0.1)),ncol=2)

testset<-matrix(c(rbinom(10,1,0.5),runif(10,0.1)),ncol=2)

get_probabilities(trset,testset,rbinom(70,1,0.6),'binary')
}
\seealso{
Function uses \code{\link[nnet]{multinom}}  and \code{\link[stats]{coef}}
}
