% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar.R
\name{add.gene.embedding}
\alias{add.gene.embedding}
\title{Add Gene Embedding to Seurat Object}
\usage{
add.gene.embedding(seu, adjm, reduction.name = "caesar", assay = NULL)
}
\arguments{
\item{seu}{A Seurat object. The Seurat object should contain pre-computed cell embeddings for dimensional reduction and expression data for genes.}

\item{adjm}{A spatial adjacency matrix that represents relationships between cells or spots in the spatial transcriptomic data. This matrix is used to calculate the gene embeddings.}

\item{reduction.name}{A character string specifying the name of the dimensional reduction method used for the cell embeddings (e.g., "ncfm", "caesar", etc.). The computed gene embeddings will be added to this slot. Default is "caesar".}

\item{assay}{A character string specifying which assay to use from the Seurat object. If NULL, the function will use the default assay set in the Seurat object.}
}
\value{
The modified Seurat object with the computed gene embeddings added to the specified dimensional reduction (`reduction.name`).
}
\description{
This function computes and adds gene embeddings to a Seurat object based on a provided adjacency matrix of spatial information and an existing cell embedding. It allows for the integration of gene-level information into the dimensional reduction of the Seurat object.
}
\examples{
data(toydata)

seu <- toydata$seu
pos <- toydata$pos

adjm <- ProFAST::AddAdj(as.matrix(pos), radius.upper = 200)
seu <- add.gene.embedding(
    seu = seu,
    adjm = adjm,
    reduction.name = "caesar",
    assay = "RNA"
)
print(seu)

}
