% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimilaritiesMethods.R
\name{as.treesimilarities}
\alias{as.treesimilarities}
\title{Function to coerce objects to a treesimilarities object.}
\usage{
as.treesimilarities(obj, ...)
}
\arguments{
\item{obj}{List with as first element the similarity matrix, and as second the forest on which it was calculated}

\item{...}{Additional arguments}
}
\value{
The function returns an object of class treesimilarities. It includes two attributes:
forest (The forest for which similarities were calculated) and sim (similarity matrix with similarities between trees in forest based on chosen similarity measure)
}
\description{
A function to coerce objects to treesimilarities objects. As an argument, it takes a list with a similaritymatrix as its first element
and a forest object as its second.
This list is then coerced to a treesimilarities object (with attributes similarity matrix and forest).
}
\examples{
require(rpart)
require(MASS)
#Function to draw a bootstrap sample from a dataset
DrawBoots <- function(dataset, i){
set.seed(2394 + i)
Boot <- dataset[sample(1:nrow(dataset), size = nrow(dataset), replace = TRUE),]
return(Boot)
}

#Function to grow a tree using rpart on a dataset
GrowTree <- function(x,y,BootsSample, minsplit = 40, minbucket = 20, maxdepth =3){
 controlrpart <- rpart.control(minsplit = minsplit, minbucket = minbucket,
 maxdepth = maxdepth, maxsurrogate = 0, maxcompete = 0)
 tree <- rpart(as.formula(paste(noquote(paste(y, "~")),
 noquote(paste(x, collapse="+")))), data = BootsSample, control = controlrpart)
 return(tree)
}

#Use functions to draw 20 boostrapsamples and grow a tree on each sample
Boots<- lapply(1:5, function(k) DrawBoots(Pima.tr ,k))
Trees <- lapply(1:5, function (i) GrowTree(x=c("npreg", "glu",  "bp",  "skin",
"bmi", "ped", "age"), y="type", Boots[[i]] ))

#Turn the lists of dataframes and rpart trees to a forest object
myforest<- forest(Pima.tr, Boots,Trees)

#Create similarity matrix based on some measure
simmatrix<-matrix(c(1,0.5,0.8,0.9,0.3, 0.5,1, 0.6,0.7,0.2, 0.8,0.6,1,0.7,0.3,
0.9,0.7,0.7,1,0.3, 0.3,0.2,0.3,0.3,1  ), 5,5,)


simobject<- as.treesimilarities(list(simmatrix,myforest))
}
