% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_random_clust_sim.R
\name{mod_random_clust_sim}
\alias{mod_random_clust_sim}
\title{Modified random cluster neutral landscape model}
\usage{
mod_random_clust_sim(x)
}
\arguments{
\item{x}{A SpatRaster object.}
}
\value{
A SpatRaster object with boundary elements.
}
\description{
Simulates a neutral landscape of the same extent and resolution as the input raster, with the same
distribution of values.
}
\examples{
data(grassland)
grassland <- terra::rast(grassland_matrix, crs = grassland_crs)
terra::ext(grassland) <- grassland_ext

simulation <- mod_random_clust_sim(grassland)
terra::plot(simulation)

}
\references{
Saura, S. & Martínez-Millán, J. (2000) Landscape patterns simulation with a modified random clusters method. Landscape Ecology, 15, 661 – 678.
}
\author{
Amy Luo
}
