% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modSel.R
\name{modSel}
\alias{modSel}
\title{Wrapper for function spatSim() which allows use on multiple datasets.}
\usage{
modSel(WIN, M0, M2, AV, RAD)
}
\arguments{
\item{WIN}{window of observation for the point patterns (MOD0 and MOD2)(see ?spatstat.geom::owin). Object of class 'sp::owin'.}

\item{M0}{data frame containing 'y' and 'x' coordinates (projected coordinate system) to compare with M2.}

\item{M2}{list of dataframes with same structure of M0, typically generated with simulacro() function.}

\item{AV}{numeric vector of the Alpha values of the simulated datasets in the same order as in the list of argument M2. Used to save the output data frame.}

\item{RAD}{numeric vector of search distances for the K-function.}
}
\value{
data frame with two columns. 'dissimilarity': dissimilarity values as computed by spatSim() function. 'compAlpha': same as AV.
}
\description{
This function uses spatSim() function to compare many simulated datasets with one, typically observed, data set.
}
\examples{
data(nzw)
data(frogsEM)  #see EM().
data(frogsLacro)  #see simulacro().

\dontrun{
frogsSum<- modSel(WIN= nzw, M0= frogsEM, M2= frogsLacro,
 AV= c(2,3,4.5,7.5,11,15,20,25), RAD= seq(0,30000,1000))
 }
}
\author{
Luca Butikofer
}
