% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM.R
\name{EM}
\alias{EM}
\title{Runs the EM algorithm.}
\usage{
EM(dataset, randompoints, sigma, pi)
}
\arguments{
\item{dataset}{the data frame to be analised (WGS84, colums order should be "year","lat","long","origin")}

\item{randompoints}{data frame of 'y' and 'x' coordinates of random points (projected coordinate system)}

\item{sigma}{starting value for the standard deviation of the natural dispersal kernel (assumed to be a half normal)}

\item{pi}{starting value for the proportion of natural points in the dataset}
}
\value{
dataset argument with two additional colums. 'dist': distance from nearest point of natural origin or nearest anchor point (see Details); 'Pnat': probability of being of natural origin.
}
\description{
Attributes to the populations in an invasion time series a probability value of being of natural origin, as opposite of anthropogenic origin.
}
\examples{
data('nzp')
data('frogs')
randp<- RPG(rpopn=1000, boundary=nzp, SP= 'random_frog')
frogsEM<- EM(dataset= frogs, randompoints= randp, sigma=6, pi=0.5)
}
\author{
Beatrix Jones, Luca Butikofer
}

