% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM.R
\name{EM}
\alias{EM}
\title{Runs the EM algorithm.}
\usage{
EM(dataset, cval = 2, randompoints)
}
\arguments{
\item{dataset}{the data frame to be analised (WGS84, colums order should be "year","lat","long","origin")}

\item{cval}{number of numeric vector of values of C to be tested for.}

\item{randompoints}{data frame of 'y' and 'x' coordinates of random points (projected coordinate system)}
}
\value{
dataset argument with two additional colums. 'dist': distance from nearest point of natural origin or nearest anchor point (see Details); 'Pnat': probability of being of natural origin.
}
\description{
Computes user-defined one dimensional dispersal kernels.
}
\examples{
data('nzp')
data('frogs')
randp<- RPG(rpopn=1000, boundary=nzp, SP= 'random_frog')
\dontrun{
frogsEM<- EM(dataset= frogs, randompoints= randp)
 }
}

