% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interventionestMC.R
\name{DAGinterventionMC}
\alias{DAGinterventionMC}
\title{Monte Carlo estimation of intervention effects for a DAG or chain of sampled DAGs}
\usage{
DAGinterventionMC(
  incidences,
  dataParams,
  sampleSize,
  sample = TRUE,
  fixNode = TRUE,
  reducedVarianceSampling = TRUE
)
}
\arguments{
\item{incidences}{a single adjacency matrix of a list of adjacency matrices
of sampled DAGs, with entry [i,j] equal to 1 when a directed edge exists from
node i to node j}

\item{dataParams}{the data and parameters used to learn the DAGs derived from the
\code{\link[BiDAG]{scoreparameters}} function of the BiDAG package}

\item{sampleSize}{the number of Monte Carlo samples to draw}

\item{sample}{logical indicating whether to sample the parameters of each node
from the posterior (TRUE, default) or to take the expectation (FALSE)}

\item{fixNode}{logical indicating whether to intervene on each node (TRUE, default)
and resample downstream nodes or to sample once and reweight the sample (FALSE)}

\item{reducedVarianceSampling}{logical indicating whether to perform Bernoulli
samping for each node (FALSE) or to sample from a distribution with the same mean
and lower variance (TRUE, default)}
}
\value{
a single matrix or a list of matrices containing the full set of
intervention effects for each input DAG. Entry [i,j] is the downstream
effect on node j of intervening on node i
(the difference observed at node j when setting node i to 1 and 0)
}
\description{
\code{DAGinterventionMC} takes a DAG or a sampled chain of DAGs (for example from
the \code{\link[BiDAG]{partitionMCMC}} function of the BiDAG package) and computes,
for binary data, a Monte Carlo estimate of the intervention effect of 
each node on all others by simulating data from the DAG. 
By default each node is intervened upon and the downstream effects
estimated by further sampling. A faster but less robust and accurate version is
also offered which reweights a single simulated dataset.
}
\examples{

scoreParam <- BiDAG::scoreparameters("bde", BiDAG::Asia)
causalmatMC <- DAGinterventionMC(BiDAG::Asiamat, scoreParam, 1e4)

}
\seealso{
\code{\link[BiDAG]{scoreparameters}}
}
