/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.GammaFunction;
import dr.math.MathUtils;

public class DirichletDistributionModel
extends AbstractModel
implements ParametricMultivariateDistributionModel {
    private Parameter countsParameter;
    private Parameter dispersionParameter;
    private boolean sumToNumberOfElements;
    public static final double ACCURACY_THRESHOLD = 1.0E-12;
    public static final boolean DEBUG = false;
    private int dim;

    public DirichletDistributionModel(Parameter parameter, Parameter parameter2, boolean bl) {
        super("dirichletDistributionModel");
        this.sumToNumberOfElements = bl;
        this.countsParameter = parameter;
        this.addVariable(this.countsParameter);
        this.dispersionParameter = parameter2;
        this.addVariable(this.dispersionParameter);
        this.dim = this.countsParameter.getSize();
    }

    @Override
    public double logPdf(double[] dArray) {
        int n;
        if (dArray.length != this.countsParameter.getSize()) {
            throw new IllegalArgumentException("data array is of the wrong dimension");
        }
        double d = 0.0;
        for (n = 0; n < this.countsParameter.getSize(); ++n) {
            d += this.countsParameter.getParameterValue(n) * this.dispersionParameter.getParameterValue(0);
        }
        double d2 = GammaFunction.lnGamma(d);
        for (n = 0; n < this.countsParameter.getSize(); ++n) {
            d2 -= GammaFunction.lnGamma(this.countsParameter.getParameterValue(n) * this.dispersionParameter.getParameterValue(0));
        }
        double d3 = 0.0;
        d3 = this.sumToNumberOfElements ? (double)this.countsParameter.getSize() : 1.0;
        d2 -= (double)this.countsParameter.getSize() * Math.log(d3);
        double d4 = 0.0;
        for (int i = 0; i < this.countsParameter.getSize(); ++i) {
            d2 += (this.countsParameter.getParameterValue(i) * this.dispersionParameter.getParameterValue(0) - 1.0) * (Math.log(dArray[i]) - Math.log(d3));
            d4 += dArray[i];
        }
        if (Math.abs(d4 - d3) > 1.0E-12) {
            d2 = Double.NEGATIVE_INFINITY;
        }
        return d2;
    }

    @Override
    public double[][] getScaleMatrix() {
        return null;
    }

    @Override
    public double[] getMean() {
        int n;
        double[] dArray = new double[this.countsParameter.getSize()];
        double d = 0.0;
        for (n = 0; n < this.countsParameter.getSize(); ++n) {
            d += this.countsParameter.getParameterValue(n) * this.dispersionParameter.getParameterValue(0);
        }
        for (n = 0; n < this.countsParameter.getSize(); ++n) {
            dArray[n] = this.countsParameter.getParameterValue(n) * this.dispersionParameter.getParameterValue(0) / d;
        }
        return dArray;
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public String getType() {
        return "dirichletDistribution";
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    public Likelihood getLikelihood() {
        return null;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return null;
    }

    @Override
    public double[] nextRandom() {
        double[] dArray = new double[this.countsParameter.getSize()];
        double d = 0.0;
        for (int i = 0; i < this.countsParameter.getSize(); ++i) {
            dArray[i] = MathUtils.nextGamma(this.countsParameter.getParameterValue(i) * this.dispersionParameter.getParameterValue(0), 1.0);
            d += dArray[i];
        }
        double[] dArray2 = new double[this.countsParameter.getSize()];
        for (int i = 0; i < this.countsParameter.getSize(); ++i) {
            dArray2[i] = dArray[i] / d;
        }
        return dArray2;
    }
}

