/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.BranchRates;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.SimpleNode;
import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evolution.util.Date;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.SimpleRootedTree;

public class TreeUtils {
    public static int getLeafCount(Tree tree, NodeRef nodeRef) {
        if (tree.isExternal(nodeRef)) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            n += TreeUtils.getLeafCount(tree, tree.getChild(nodeRef, i));
        }
        return n;
    }

    public static double getTreeLength(Tree tree) {
        double d = 0.0;
        for (int i = 0; i < tree.getNodeCount(); ++i) {
            d += tree.getBranchLength(tree.getNode(i));
        }
        return d;
    }

    public static double getTreeLength(Tree tree, NodeRef nodeRef) {
        int n = tree.getChildCount(nodeRef);
        if (n == 0) {
            return tree.getBranchLength(nodeRef);
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += TreeUtils.getTreeLength(tree, tree.getChild(nodeRef, i));
        }
        if (nodeRef != tree.getRoot()) {
            d += tree.getBranchLength(nodeRef);
        }
        return d;
    }

    public static double getSubTreeLength(Tree tree, Set<Taxon> set) {
        double[] dArray = new double[]{0.0};
        TreeUtils.getSubTreeLength(tree, tree.getRoot(), set, dArray);
        return dArray[0];
    }

    private static int getSubTreeLength(Tree tree, NodeRef nodeRef, Set<Taxon> set, double[] dArray) {
        int n = tree.getChildCount(nodeRef);
        if (n == 0) {
            if (set.contains(tree.getNodeTaxon(nodeRef))) {
                dArray[0] = dArray[0] + tree.getBranchLength(nodeRef);
                return 1;
            }
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += TreeUtils.getSubTreeLength(tree, tree.getChild(nodeRef, i), set, dArray);
        }
        if (n2 > 0 && n2 < set.size()) {
            if (nodeRef != tree.getRoot()) {
                dArray[0] = dArray[0] + tree.getBranchLength(nodeRef);
            }
            return n2;
        }
        return 0;
    }

    public static double getPathLength(Tree tree, NodeRef nodeRef, NodeRef nodeRef2) {
        NodeRef nodeRef3 = TreeUtils.getCommonAncestorNode(tree, nodeRef, nodeRef2);
        return 2.0 * tree.getNodeHeight(nodeRef3) - tree.getNodeHeight(nodeRef) - tree.getNodeHeight(nodeRef2);
    }

    public static double getMinNodeHeight(Tree tree, NodeRef nodeRef) {
        int n = tree.getChildCount(nodeRef);
        if (n == 0) {
            return tree.getNodeHeight(nodeRef);
        }
        double d = Double.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            double d2 = TreeUtils.getMinNodeHeight(tree, tree.getChild(nodeRef, i));
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static boolean isUltrametric(Tree tree) {
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            if (tree.getNodeHeight(tree.getExternalNode(i)) == 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isBinary(Tree tree) {
        for (int i = 0; i < tree.getInternalNodeCount(); ++i) {
            if (tree.getChildCount(tree.getInternalNode(i)) <= 2) continue;
            return false;
        }
        return true;
    }

    public static Set<String> getLeafSet(Tree tree) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = tree.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            Taxon taxon = tree.getTaxon(i);
            hashSet.add(taxon.getId());
        }
        return hashSet;
    }

    public static Set<String> getLeavesForTaxa(Tree tree, TaxonList taxonList) throws MissingTaxonException {
        HashSet<String> hashSet = new HashSet<String>();
        int n = taxonList.getTaxonCount();
        int n2 = tree.getExternalNodeCount();
        for (int i = 0; i < n; ++i) {
            Taxon taxon = taxonList.getTaxon(i);
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                NodeRef nodeRef = tree.getExternalNode(j);
                if (!tree.getNodeTaxon(nodeRef).getId().equals(taxon.getId())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new MissingTaxonException(taxon);
            }
            hashSet.add(taxon.getId());
        }
        return hashSet;
    }

    public static Set<String> getDescendantLeaves(Tree tree, NodeRef nodeRef) {
        HashSet<String> hashSet = new HashSet<String>();
        TreeUtils.getDescendantLeaves(tree, nodeRef, hashSet);
        return hashSet;
    }

    private static void getDescendantLeaves(Tree tree, NodeRef nodeRef, Set<String> set) {
        if (tree.isExternal(nodeRef)) {
            set.add(tree.getTaxonId(nodeRef.getNumber()));
        } else {
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                TreeUtils.getDescendantLeaves(tree, nodeRef2, set);
            }
        }
    }

    public static Set<NodeRef> getExternalNodes(Tree tree, NodeRef nodeRef) {
        HashSet<NodeRef> hashSet = new HashSet<NodeRef>();
        TreeUtils.getExternalNodes(tree, nodeRef, hashSet);
        return hashSet;
    }

    private static void getExternalNodes(Tree tree, NodeRef nodeRef, Set<NodeRef> set) {
        if (tree.isExternal(nodeRef)) {
            set.add(nodeRef);
        } else {
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                TreeUtils.getExternalNodes(tree, nodeRef2, set);
            }
        }
    }

    public static NodeRef getCommonAncestorNode(Tree tree, NodeRef nodeRef, NodeRef nodeRef2) {
        HashSet<NodeRef> hashSet = new HashSet<NodeRef>();
        NodeRef nodeRef3 = nodeRef;
        while (nodeRef3 != null) {
            hashSet.add(nodeRef3);
            nodeRef3 = tree.getParent(nodeRef3);
        }
        nodeRef3 = nodeRef2;
        NodeRef nodeRef4 = null;
        while (nodeRef3 != null && nodeRef4 == null) {
            if (hashSet.contains(nodeRef3)) {
                nodeRef4 = nodeRef3;
            }
            nodeRef3 = tree.getParent(nodeRef3);
        }
        return nodeRef4;
    }

    public static NodeRef getCommonAncestorNode(Tree tree, Set<String> set) {
        int n = set.size();
        if (n == 0) {
            throw new IllegalArgumentException("No leaf nodes selected");
        }
        NodeRef[] nodeRefArray = new NodeRef[]{null};
        TreeUtils.getCommonAncestorNode(tree, tree.getRoot(), set, n, nodeRefArray);
        return nodeRefArray[0];
    }

    private static int getCommonAncestorNode(Tree tree, NodeRef nodeRef, Set<String> set, int n, NodeRef[] nodeRefArray) {
        if (tree.isExternal(nodeRef)) {
            if (set.contains(tree.getTaxonId(nodeRef.getNumber()))) {
                if (n == 1) {
                    nodeRefArray[0] = nodeRef;
                }
                return 1;
            }
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            n2 += TreeUtils.getCommonAncestorNode(tree, nodeRef2, set, n, nodeRefArray);
            if (nodeRefArray[0] != null) break;
        }
        if (nodeRefArray[0] == null && n2 == n) {
            nodeRefArray[0] = nodeRef;
        }
        return n2;
    }

    public static BitSet getTipsBitSetForTaxa(Tree tree, TaxonList taxonList) throws MissingTaxonException {
        BitSet bitSet = new BitSet();
        for (int n : TreeUtils.getTipsForTaxa(tree, taxonList)) {
            bitSet.set(n);
        }
        return bitSet;
    }

    public static Set<Integer> getTipsForTaxa(Tree tree, TaxonList taxonList) throws MissingTaxonException {
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        for (int i = 0; i < taxonList.getTaxonCount(); ++i) {
            Taxon taxon = taxonList.getTaxon(i);
            boolean bl = false;
            for (int j = 0; j < tree.getExternalNodeCount(); ++j) {
                NodeRef nodeRef = tree.getExternalNode(j);
                if (!tree.getNodeTaxon(nodeRef).getId().equals(taxon.getId())) continue;
                linkedHashSet.add(nodeRef.getNumber());
                bl = true;
                break;
            }
            if (bl) continue;
            throw new MissingTaxonException(taxon);
        }
        return linkedHashSet;
    }

    public static boolean isMonophyletic(Tree tree, Set<String> set) {
        return TreeUtils.isMonophyletic(tree, set, Collections.emptySet());
    }

    public static boolean isMonophyletic(Tree tree, Set<String> set, Set<String> set2) {
        int n = set.size();
        if (n == 1) {
            return true;
        }
        if (n == tree.getExternalNodeCount()) {
            return true;
        }
        if (n == 0) {
            throw new IllegalArgumentException("No leaf nodes selected");
        }
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        boolean[] blArray = new boolean[]{false};
        TreeUtils.isMonophyletic(tree, tree.getRoot(), set, set2, n, nArray, nArray2, blArray);
        return blArray[0];
    }

    private static boolean isMonophyletic(Tree tree, NodeRef nodeRef, Set<String> set, Set<String> set2, int n, int[] nArray, int[] nArray2, boolean[] blArray) {
        if (tree.isExternal(nodeRef)) {
            String string = tree.getNodeTaxon(nodeRef).getId();
            nArray[0] = set.contains(string) ? 1 : 0;
            nArray2[0] = !set2.contains(string) ? 1 : 0;
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            boolean bl = TreeUtils.isMonophyletic(tree, nodeRef2, set, set2, n, nArray, nArray2, blArray);
            n2 += nArray[0];
            n3 += nArray2[0];
            if (!bl) continue;
            return true;
        }
        nArray[0] = n2;
        nArray2[0] = n3;
        if (n2 == n3 && n3 == n) {
            blArray[0] = true;
            return true;
        }
        return false;
    }

    public static NodeRef getCommonAncestor(Tree tree, NodeRef nodeRef, NodeRef nodeRef2) {
        while (nodeRef != nodeRef2) {
            if (tree.getNodeHeight(nodeRef) < tree.getNodeHeight(nodeRef2)) {
                nodeRef = tree.getParent(nodeRef);
                continue;
            }
            nodeRef2 = tree.getParent(nodeRef2);
        }
        return nodeRef;
    }

    public static NodeRef getCommonAncestorSafely(Tree tree, NodeRef nodeRef, NodeRef nodeRef2) {
        while (nodeRef != nodeRef2) {
            if (tree.isRoot(nodeRef)) {
                return nodeRef;
            }
            if (tree.isRoot(nodeRef2)) {
                return nodeRef2;
            }
            if (tree.getNodeHeight(nodeRef) < tree.getNodeHeight(nodeRef2)) {
                nodeRef = tree.getParent(nodeRef);
                continue;
            }
            nodeRef2 = tree.getParent(nodeRef2);
        }
        return nodeRef;
    }

    public static NodeRef getCommonAncestor(Tree tree, int[] nArray) {
        NodeRef nodeRef = tree.getNode(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            nodeRef = TreeUtils.getCommonAncestor(tree, nodeRef, tree.getNode(nArray[i]));
        }
        return nodeRef;
    }

    public static int largestClade(Tree tree, double d) {
        return TreeUtils.largestClade(tree, tree.getRoot(), d, new double[]{0.0, 0.0});
    }

    private static int largestClade(Tree tree, NodeRef nodeRef, double d, double[] dArray) {
        if (tree.isExternal(nodeRef)) {
            dArray[0] = tree.getNodeHeight(nodeRef);
            dArray[1] = tree.getNodeHeight(nodeRef);
            return 1;
        }
        int n = TreeUtils.largestClade(tree, tree.getChild(nodeRef, 0), d, dArray);
        double d2 = dArray[0];
        double d3 = dArray[1];
        int n2 = TreeUtils.largestClade(tree, tree.getChild(nodeRef, 1), d, dArray);
        d2 = Math.min(d2, dArray[0]);
        d3 = Math.max(d3, dArray[1]);
        dArray[0] = d2;
        dArray[1] = d3;
        if (d3 - d2 < d) {
            return n + n2;
        }
        return Math.max(n, n2);
    }

    public static int getParsimonySteps(Tree tree, Set set) {
        int[] nArray = new int[]{0};
        TreeUtils.getParsimonySteps(tree, tree.getRoot(), set, nArray);
        return nArray[0];
    }

    private static int getParsimonySteps(Tree tree, NodeRef nodeRef, Set set, int[] nArray) {
        int n;
        if (tree.isExternal(nodeRef)) {
            return set.contains(tree.getTaxonId(nodeRef.getNumber())) ? 1 : 2;
        }
        int n2 = n = TreeUtils.getParsimonySteps(tree, tree.getChild(nodeRef, 0), set, nArray);
        for (int i = 1; i < tree.getChildCount(nodeRef); ++i) {
            int n3 = TreeUtils.getParsimonySteps(tree, tree.getChild(nodeRef, i), set, nArray);
            n = n3 | n;
            n2 = n3 & n2;
        }
        if (n2 == 0) {
            nArray[0] = nArray[0] + 1;
        }
        return n;
    }

    public static double getParsimonyState(Tree tree, NodeRef nodeRef, Set set) {
        int n = TreeUtils.getParsimonyStateAtNode(tree, nodeRef, set);
        switch (n) {
            case 1: {
                return 0.0;
            }
            case 2: {
                return 1.0;
            }
        }
        return 0.5;
    }

    private static int getParsimonyStateAtNode(Tree tree, NodeRef nodeRef, Set set) {
        int n;
        if (tree.isExternal(nodeRef)) {
            return set.contains(tree.getTaxonId(nodeRef.getNumber())) ? 1 : 2;
        }
        int n2 = n = TreeUtils.getParsimonyStateAtNode(tree, tree.getChild(nodeRef, 0), set);
        for (int i = 1; i < tree.getChildCount(nodeRef); ++i) {
            int n3 = TreeUtils.getParsimonyStateAtNode(tree, tree.getChild(nodeRef, i), set);
            n = n3 | n;
            n2 = n3 & n2;
        }
        return n;
    }

    public static NodeRef preorderSuccessor(Tree tree, NodeRef nodeRef) {
        NodeRef nodeRef2 = null;
        if (tree.isExternal(nodeRef)) {
            NodeRef nodeRef3 = nodeRef;
            NodeRef nodeRef4 = null;
            do {
                if (tree.isRoot(nodeRef3)) {
                    nodeRef2 = nodeRef3;
                    break;
                }
                nodeRef4 = nodeRef3;
            } while (tree.getChild(nodeRef3 = tree.getParent(nodeRef3), tree.getChildCount(nodeRef3) - 1) == nodeRef4);
            if (nodeRef2 == null) {
                for (int i = 0; i < tree.getChildCount(nodeRef3) - 1; ++i) {
                    if (tree.getChild(nodeRef3, i) != nodeRef4) continue;
                    nodeRef2 = tree.getChild(nodeRef3, i + 1);
                    break;
                }
            }
        } else {
            nodeRef2 = tree.getChild(nodeRef, 0);
        }
        return nodeRef2;
    }

    public static void postOrderTraversalList(Tree tree, int[] nArray) {
        int n = tree.getNodeCount();
        if (nArray.length != n) {
            throw new IllegalArgumentException("Illegal list length");
        }
        int n2 = n - 1;
        int n3 = n - 1;
        nArray[n2] = tree.getRoot().getNumber();
        while (n3 > 0) {
            NodeRef nodeRef = tree.getNode(nArray[n2]);
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                nArray[--n3] = tree.getChild(nodeRef, i).getNumber();
            }
            --n2;
        }
    }

    public static void preOrderTraversalList(Tree tree, int[] nArray) {
        int n = tree.getNodeCount();
        if (nArray.length != n) {
            throw new IllegalArgumentException("Illegal list length");
        }
        nArray[0] = tree.getRoot().getNumber();
        TreeUtils.preOrderTraversalList(tree, 0, nArray);
    }

    static int preOrderTraversalList(Tree tree, int n, int[] nArray) {
        NodeRef nodeRef = tree.getNode(nArray[n]);
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            nArray[++n] = nodeRef2.getNumber();
            if (tree.isExternal(nodeRef2)) continue;
            n = TreeUtils.preOrderTraversalList(tree, n, nArray);
        }
        return n;
    }

    public static NodeRef postorderSuccessor(Tree tree, NodeRef nodeRef) {
        NodeRef nodeRef2 = null;
        NodeRef nodeRef3 = tree.getParent(nodeRef);
        if (tree.getRoot() == nodeRef) {
            nodeRef2 = nodeRef;
        } else {
            if (tree.getChild(nodeRef3, tree.getChildCount(nodeRef3) - 1) == nodeRef) {
                return nodeRef3;
            }
            for (int i = 0; i < tree.getChildCount(nodeRef3) - 1; ++i) {
                if (tree.getChild(nodeRef3, i) != nodeRef) continue;
                nodeRef2 = tree.getChild(nodeRef3, i + 1);
                break;
            }
        }
        while (tree.getChildCount(nodeRef2) > 0) {
            nodeRef2 = tree.getChild(nodeRef2, 0);
        }
        return nodeRef2;
    }

    public static NodeRef findNodeWithAttribute(Tree tree, String string) {
        NodeRef nodeRef;
        NodeRef nodeRef2 = nodeRef = tree.getRoot();
        do {
            if (tree.getNodeAttribute(nodeRef2, string) == null) continue;
            return nodeRef2;
        } while ((nodeRef2 = TreeUtils.preorderSuccessor(tree, nodeRef2)) != nodeRef);
        return null;
    }

    public static Date findMostRecentDate(Tree tree) {
        Date date = null;
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            Taxon taxon = tree.getNodeTaxon(tree.getExternalNode(i));
            Date date2 = (Date)taxon.getAttribute("date");
            if (date2 == null || date != null && !date2.after(date)) continue;
            date = date2;
        }
        return date;
    }

    public static String newick(Tree tree) {
        StringBuffer stringBuffer = new StringBuffer();
        TreeUtils.newick(tree, tree.getRoot(), true, BranchLengthType.LENGTHS_AS_TIME, null, null, null, null, stringBuffer);
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public static String newick(Tree tree, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(n);
        TreeUtils.newick(tree, tree.getRoot(), true, BranchLengthType.LENGTHS_AS_TIME, numberFormat, null, null, null, stringBuffer);
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public static String newick(Tree tree, BranchRates branchRates) {
        StringBuffer stringBuffer = new StringBuffer();
        TreeUtils.newick(tree, tree.getRoot(), true, BranchLengthType.LENGTHS_AS_SUBSTITUTIONS, null, branchRates, null, null, stringBuffer);
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public static String newick(Tree tree, TreeTraitProvider[] treeTraitProviderArray) {
        StringBuffer stringBuffer = new StringBuffer();
        TreeUtils.newick(tree, tree.getRoot(), true, BranchLengthType.LENGTHS_AS_TIME, null, null, treeTraitProviderArray, null, stringBuffer);
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public static String newickNoLengths(Tree tree) {
        StringBuffer stringBuffer = new StringBuffer();
        TreeUtils.newick(tree, tree.getRoot(), true, BranchLengthType.NO_BRANCH_LENGTHS, null, null, null, null, stringBuffer);
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public static void newick(Tree tree, NodeRef nodeRef, boolean bl, BranchLengthType branchLengthType, NumberFormat numberFormat, BranchRates branchRates, TreeTraitProvider[] treeTraitProviderArray, Map<String, Integer> map, StringBuffer stringBuffer) {
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (tree.isExternal(nodeRef)) {
            if (!bl) {
                int n = nodeRef.getNumber();
                if (map != null) {
                    stringBuffer.append(map.get(tree.getTaxonId(n)));
                } else {
                    stringBuffer.append(n + 1);
                }
            } else {
                String string = tree.getTaxonId(nodeRef.getNumber());
                if (string.contains(" ") || string.contains(":") || string.contains(";") || string.contains(",")) {
                    stringBuffer.append("\"");
                    stringBuffer.append(string);
                    stringBuffer.append("\"");
                } else {
                    stringBuffer.append(string);
                }
            }
        } else {
            stringBuffer.append("(");
            TreeUtils.newick(tree, tree.getChild(nodeRef, 0), bl, branchLengthType, numberFormat, branchRates, treeTraitProviderArray, map, stringBuffer);
            for (int i = 1; i < tree.getChildCount(nodeRef); ++i) {
                stringBuffer.append(",");
                TreeUtils.newick(tree, tree.getChild(nodeRef, i), bl, branchLengthType, numberFormat, branchRates, treeTraitProviderArray, map, stringBuffer);
            }
            stringBuffer.append(")");
        }
        TreeUtils.writeTreeTraits(stringBuffer, tree, nodeRef, treeTraitProviderArray, TreeTrait.Intent.NODE);
        if (nodeRef2 != null && branchLengthType != BranchLengthType.NO_BRANCH_LENGTHS) {
            stringBuffer.append(":");
            TreeUtils.writeTreeTraits(stringBuffer, tree, nodeRef, treeTraitProviderArray, TreeTrait.Intent.BRANCH);
            if (branchLengthType != BranchLengthType.NO_BRANCH_LENGTHS) {
                double d = tree.getNodeHeight(nodeRef2) - tree.getNodeHeight(nodeRef);
                if (branchLengthType == BranchLengthType.LENGTHS_AS_SUBSTITUTIONS) {
                    if (branchRates == null) {
                        throw new IllegalArgumentException("No BranchRates provided");
                    }
                    d *= branchRates.getBranchRate(tree, nodeRef);
                }
                String string = numberFormat != null ? numberFormat.format(d) : String.valueOf(d);
                stringBuffer.append(string);
            }
        }
    }

    private static void writeTreeTraits(StringBuffer stringBuffer, Tree tree, NodeRef nodeRef, TreeTraitProvider[] treeTraitProviderArray, TreeTrait.Intent intent) {
        if (treeTraitProviderArray != null) {
            boolean bl = false;
            for (TreeTraitProvider treeTraitProvider : treeTraitProviderArray) {
                TreeTrait[] treeTraitArray;
                for (TreeTrait treeTrait : treeTraitArray = treeTraitProvider.getTreeTraits()) {
                    String string;
                    if (!treeTrait.getLoggable() || treeTrait.getIntent() != intent || (string = treeTrait.getTraitString(tree, nodeRef)) == null) continue;
                    if (!bl) {
                        stringBuffer.append("[&");
                        bl = true;
                    } else {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(treeTrait.getTraitName());
                    stringBuffer.append("=");
                    stringBuffer.append(string);
                }
            }
            if (bl) {
                stringBuffer.append("]");
            }
        }
    }

    public static String uniqueNewick(Tree tree, NodeRef nodeRef) {
        int n;
        if (tree.isExternal(nodeRef)) {
            return tree.getNodeTaxon(nodeRef).getId();
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < tree.getChildCount(nodeRef); ++n) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, n);
            arrayList.add(TreeUtils.uniqueNewick(tree, nodeRef2));
        }
        Collections.sort(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            stringBuffer.append((String)arrayList.get(n));
            if (n >= arrayList.size() - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static Tree rotateByName(Tree tree) {
        return new SimpleTree(TreeUtils.rotateNodeByName(tree, tree.getRoot()));
    }

    private static SimpleNode rotateNodeByName(Tree tree, NodeRef nodeRef) {
        String string;
        if (tree.isExternal(nodeRef)) {
            return new SimpleNode(tree, nodeRef);
        }
        SimpleNode simpleNode = new SimpleNode(tree, nodeRef);
        NodeRef nodeRef2 = tree.getChild(nodeRef, 0);
        NodeRef nodeRef3 = tree.getChild(nodeRef, 1);
        String string2 = TreeUtils.uniqueNewick(tree, nodeRef2);
        if (string2.compareTo(string = TreeUtils.uniqueNewick(tree, nodeRef3)) > 0) {
            simpleNode.addChild(TreeUtils.rotateNodeByName(tree, nodeRef3));
            simpleNode.addChild(TreeUtils.rotateNodeByName(tree, nodeRef2));
        } else {
            simpleNode.addChild(TreeUtils.rotateNodeByName(tree, nodeRef2));
            simpleNode.addChild(TreeUtils.rotateNodeByName(tree, nodeRef3));
        }
        return simpleNode;
    }

    public static MutableTree rotateTreeByComparator(Tree tree, Comparator<NodeRef> comparator) {
        return new SimpleTree(TreeUtils.rotateTreeByComparator(tree, tree.getRoot(), comparator));
    }

    private static SimpleNode rotateTreeByComparator(Tree tree, NodeRef nodeRef, Comparator<NodeRef> comparator) {
        SimpleNode simpleNode = new SimpleNode();
        simpleNode.setHeight(tree.getNodeHeight(nodeRef));
        simpleNode.setRate(tree.getNodeRate(nodeRef));
        simpleNode.setId(tree.getTaxonId(nodeRef.getNumber()));
        simpleNode.setNumber(nodeRef.getNumber());
        simpleNode.setTaxon(tree.getNodeTaxon(nodeRef));
        if (!tree.isExternal(nodeRef)) {
            NodeRef nodeRef2;
            NodeRef nodeRef3 = tree.getChild(nodeRef, 0);
            if (comparator.compare(nodeRef3, nodeRef2 = tree.getChild(nodeRef, 1)) > 0) {
                simpleNode.addChild(TreeUtils.rotateTreeByComparator(tree, nodeRef2, comparator));
                simpleNode.addChild(TreeUtils.rotateTreeByComparator(tree, nodeRef3, comparator));
            } else {
                simpleNode.addChild(TreeUtils.rotateTreeByComparator(tree, nodeRef3, comparator));
                simpleNode.addChild(TreeUtils.rotateTreeByComparator(tree, nodeRef2, comparator));
            }
        }
        return simpleNode;
    }

    public static Comparator<NodeRef> createNodeDensityComparator(final Tree tree) {
        return new Comparator<NodeRef>(){

            @Override
            public int compare(NodeRef nodeRef, NodeRef nodeRef2) {
                return TreeUtils.getLeafCount(tree, nodeRef2) - TreeUtils.getLeafCount(tree, nodeRef);
            }

            public boolean equals(NodeRef nodeRef, NodeRef nodeRef2) {
                return TreeUtils.getLeafCount(tree, nodeRef) == TreeUtils.getLeafCount(tree, nodeRef2);
            }
        };
    }

    public static Comparator<NodeRef> createNodeDensityMinNodeHeightComparator(final Tree tree) {
        return new Comparator<NodeRef>(){

            @Override
            public int compare(NodeRef nodeRef, NodeRef nodeRef2) {
                int n = TreeUtils.getLeafCount(tree, nodeRef) - TreeUtils.getLeafCount(tree, nodeRef2);
                if (n != 0) {
                    return n;
                }
                double d = TreeUtils.getMinNodeHeight(tree, nodeRef2) - TreeUtils.getMinNodeHeight(tree, nodeRef);
                if (d > 0.0) {
                    return 1;
                }
                if (d < 0.0) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static boolean allDisjoint(SimpleNode[] simpleNodeArray) {
        Set[] setArray = new Set[simpleNodeArray.length];
        for (int i = 0; i < simpleNodeArray.length; ++i) {
            setArray[i] = TreeUtils.getLeafSet(new SimpleTree(simpleNodeArray[i]));
            for (int j = 0; j < i; ++j) {
                HashSet hashSet = new HashSet(setArray[j]);
                hashSet.retainAll(setArray[i]);
                if (hashSet.size() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equal(Tree tree, Tree tree2) {
        return TreeUtils.uniqueNewick(tree, tree.getRoot()).equals(TreeUtils.uniqueNewick(tree2, tree2.getRoot()));
    }

    private static Node convertToJebl(Tree tree, NodeRef nodeRef, SimpleRootedTree simpleRootedTree) {
        if (tree.isExternal(nodeRef)) {
            String string = tree.getTaxonId(nodeRef.getNumber());
            Node node = simpleRootedTree.createExternalNode(jebl.evolution.taxa.Taxon.getTaxon(string));
            simpleRootedTree.setHeight(node, tree.getNodeHeight(nodeRef));
            return node;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            Node node = TreeUtils.convertToJebl(tree, nodeRef2, simpleRootedTree);
            simpleRootedTree.setHeight(node, tree.getNodeHeight(nodeRef2));
            arrayList.add(node);
        }
        return simpleRootedTree.createInternalNode(arrayList);
    }

    public static SimpleRootedTree asJeblTree(Tree tree) {
        SimpleRootedTree simpleRootedTree = new SimpleRootedTree();
        TreeUtils.convertToJebl(tree, tree.getRoot(), simpleRootedTree);
        simpleRootedTree.setHeight(simpleRootedTree.getRootNode(), tree.getNodeHeight(tree.getRoot()));
        return simpleRootedTree;
    }

    public static Set<Set<String>> getClades(Tree tree) {
        HashSet<Set<String>> hashSet = new HashSet<Set<String>>();
        TreeUtils.getClades(tree, tree.getRoot(), null, hashSet);
        return hashSet;
    }

    private static void getClades(Tree tree, NodeRef nodeRef, Set<String> set, Set<Set<String>> set2) {
        if (tree.isExternal(nodeRef)) {
            set.add(tree.getTaxonId(nodeRef.getNumber()));
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                TreeUtils.getClades(tree, nodeRef2, hashSet, set2);
            }
            if (set != null) {
                set.addAll(hashSet);
                set2.add(hashSet);
            }
        }
    }

    public static boolean isCompatible(Tree tree, Set<Set<String>> set) {
        return TreeUtils.isCompatible(tree, tree.getRoot(), null, set);
    }

    private static boolean isCompatible(Tree tree, NodeRef nodeRef, Set<String> set, Set<Set<String>> set2) {
        if (tree.isExternal(nodeRef)) {
            set.add(tree.getTaxonId(nodeRef.getNumber()));
            return true;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef object = tree.getChild(nodeRef, i);
            if (TreeUtils.isCompatible(tree, object, hashSet, set2)) continue;
            return false;
        }
        if (set != null) {
            for (Set<String> set3 : set2) {
                HashSet<String> hashSet2 = new HashSet<String>(set3);
                hashSet2.retainAll(hashSet);
                if (hashSet2.size() == 0 || hashSet2.size() == hashSet.size() || hashSet2.size() == set3.size()) continue;
                return false;
            }
            set.addAll(hashSet);
        }
        return true;
    }

    public static void correctBranchLengthToGetUltrametricTree(Tree tree, double d) {
    }

    private void setHeight(Tree tree, NodeRef nodeRef, double d) {
        if (tree.getChildCount(nodeRef) == 0) {
            // empty if block
        }
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
        }
    }

    public static class MissingTaxonException
    extends Exception {
        private static final long serialVersionUID = 8468656622238269963L;

        public MissingTaxonException(Taxon taxon) {
            super(taxon.getId());
        }
    }

    public static enum BranchLengthType {
        NO_BRANCH_LENGTHS,
        LENGTHS_AS_TIME,
        LENGTHS_AS_SUBSTITUTIONS;

    }
}

