/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.KMLCoordinates;
import dr.geo.Polygon2D;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Element;

public class NewPolygon2D {
    public static final String POLYGON = "polygon";
    public static final String CLOSED = "closed";
    public static final String FILL_VALUE = "fillValue";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(KMLCoordinates.class), AttributeRule.newBooleanRule("closed", true), AttributeRule.newDoubleRule("fillValue", true)};

        @Override
        public String getParserName() {
            return NewPolygon2D.POLYGON;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            KMLCoordinates kMLCoordinates = (KMLCoordinates)xMLObject.getChild(KMLCoordinates.class);
            boolean bl = xMLObject.getAttribute(NewPolygon2D.CLOSED, false);
            if (!bl && kMLCoordinates.length < 3 || bl && kMLCoordinates.length < 4) {
                throw new XMLParseException("Insufficient points in polygon '" + xMLObject.getId() + "' to define a polygon in 2D");
            }
            NewPolygon2D newPolygon2D = new NewPolygon2D();
            newPolygon2D.moveTo(new Point2D.Double(kMLCoordinates.x[0], kMLCoordinates.y[0]));
            int n = kMLCoordinates.length;
            if (bl) {
                --n;
            }
            for (int i = 1; i < n; ++i) {
                newPolygon2D.lineTo(new Point2D.Double(kMLCoordinates.x[i], kMLCoordinates.y[i]));
            }
            newPolygon2D.lineTo(new Point2D.Double(kMLCoordinates.x[0], kMLCoordinates.y[0]));
            newPolygon2D.setFillValue(xMLObject.getAttribute(NewPolygon2D.FILL_VALUE, 0.0));
            return newPolygon2D;
        }

        @Override
        public String getParserDescription() {
            return "This element represents a polygon.";
        }

        @Override
        public Class getReturnType() {
            return Polygon2D.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private double fillValue;
    private GeneralPath path;

    public NewPolygon2D(GeneralPath generalPath) {
        this.path = generalPath;
    }

    public NewPolygon2D(Element element) {
        List list = element.getChildren();
        for (Element element2 : list) {
            if (!element2.getName().equals("coordinates")) continue;
            String string = element2.getTextTrim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            int n = stringTokenizer.countTokens();
            this.path = new GeneralPath();
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
                if (stringTokenizer2.countTokens() != 3) {
                    throw new IllegalArgumentException("All KML coordinates must contain (X,Y,Z) values.  Three dimensions not found in element '" + string2 + "'");
                }
                float f = Float.valueOf(stringTokenizer2.nextToken()).floatValue();
                float f2 = Float.valueOf(stringTokenizer2.nextToken()).floatValue();
                if (i == 0) {
                    this.path.moveTo(f, f2);
                    continue;
                }
                this.path.lineTo(f, f2);
            }
        }
    }

    public NewPolygon2D() {
        this.path = new GeneralPath();
    }

    public void moveTo(Point2D point2D) {
        this.path.moveTo((float)point2D.getX(), (float)point2D.getY());
    }

    public void lineTo(Point2D point2D) {
        this.path.lineTo((float)point2D.getX(), (float)point2D.getY());
    }

    public boolean contains(Point2D point2D) {
        return this.path.contains(point2D);
    }

    public void closePath() {
        this.path.closePath();
    }

    public void setFillValue(double d) {
        this.fillValue = d;
    }

    public double getFillValue() {
        return this.fillValue;
    }

    public NewPolygon2D clip(Rectangle2D rectangle2D) {
        Area area = new Area(this.path);
        area.intersect(new Area(rectangle2D));
        PathIterator pathIterator = area.getPathIterator(null);
        double[] dArray = new double[2];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            System.err.println(":" + dArray[0] + dArray[1] + "\n");
            pathIterator.next();
        }
        System.exit(-1);
        GeneralPath generalPath = new GeneralPath(area);
        generalPath.closePath();
        NewPolygon2D newPolygon2D = new NewPolygon2D(generalPath);
        newPolygon2D.setFillValue(this.getFillValue());
        return newPolygon2D;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("polygon(");
        stringBuffer.append(this.fillValue);
        stringBuffer.append(")[\n");
        PathIterator pathIterator = this.path.getPathIterator(null);
        float[] fArray = new float[2];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            Point2D.Double double_ = new Point2D.Double(fArray[0], fArray[1]);
            stringBuffer.append("\t");
            stringBuffer.append(double_);
            stringBuffer.append("\n");
            pathIterator.next();
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        NewPolygon2D newPolygon2D = new NewPolygon2D();
        newPolygon2D.moveTo(new Point2D.Double(-10.0, -10.0));
        newPolygon2D.lineTo(new Point2D.Double(-10.0, 50.0));
        newPolygon2D.lineTo(new Point2D.Double(10.0, 50.0));
        newPolygon2D.lineTo(new Point2D.Double(10.0, -10.0));
        newPolygon2D.lineTo(new Point2D.Double(-10.0, -10.0));
        System.out.println(newPolygon2D);
        System.out.println("");
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        System.out.println("polygon contains " + double_ + ": " + newPolygon2D.contains(double_));
        double_ = new Point2D.Double(100.0, 100.0);
        System.out.println("polygon contains " + double_ + ": " + newPolygon2D.contains(double_));
        System.out.println("");
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
        System.out.println(double_2);
        NewPolygon2D newPolygon2D2 = newPolygon2D.clip(double_2);
        System.out.println(newPolygon2D2);
    }
}

