% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.BchronCalibratedDates.R
\name{plot.BchronCalibratedDates}
\alias{plot.BchronCalibratedDates}
\title{Plot calibrated dates from a BchronCalibrate run}
\usage{
\method{plot}{BchronCalibratedDates}(
  x,
  withPositions = ifelse(length(x) > 1 & !is.null(x[[1]]$positions), TRUE, FALSE),
  dateHeight = 100,
  dateLabels = TRUE,
  fillCol = "darkslategray",
  withHDR = TRUE,
  ageScale = c("bp", "bc", "b2k"),
  scaleReverse = TRUE,
  ...
)
}
\arguments{
\item{x}{Output from \code{\link{BchronCalibrate}}}

\item{withPositions}{Whether to plot with positions (i.e. using the position values as the y axis). By detault TRUE if \code{x} has more than one date and contains positions}

\item{dateHeight}{The height of the dates in the plot in the same units as the position values. Only relevant if \code{withPositions=TRUE}.}

\item{dateLabels}{Whether to add the names of the dates to the left of them. Default TRUE}

\item{fillCol}{A colour to fill the date densities when \code{withPositions} is TRUE, or HDR ranges when it is FALSE}

\item{withHDR}{Whether to plot the 95\% highest density region values}

\item{ageScale}{Either \code{bp} for years before present, \code{bc} for years BC/AD (BC will be negative), \code{b2k} for years before 2000. Others not supported (yet).}

\item{scaleReverse}{Whether to reverse the x-axis scale. Defaults to TRUE which works best for dates presented in e.g. years BP}

\item{...}{Other arguments to plot (currently ignored)}
}
\description{
Plots calibrated radiocarbon dates from a \code{\link{BchronCalibrate}} run. Has options to plot on a position (usually depth) scale if supplied with the original run
}
\details{
These plots are intended to be pretty basic and used simply for quick information. Users are encouraged to learn the R plotting features to produce publication quality graphics
}
\seealso{
\code{\link{BchronCalibrate}}, \code{\link{Bchronology}}, \code{\link{BchronRSL}}, \code{\link{BchronDensity}}, \code{\link{BchronDensityFast}}
}
