% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCorrelationDensity.r
\name{correlationPlot}
\alias{correlationPlot}
\title{Flexible function to create correlation density plots}
\usage{
correlationPlot(mat, density = "smooth", thin = "auto",
  method = "pearson", whichParameters = NULL, ...)
}
\arguments{
\item{mat}{object of class "bayesianOutput" or a matrix or data frame of variables}

\item{density}{type of plot to do. Either "smooth" (default), "corellipseCor", or "ellipse"}

\item{thin}{thinning of the matrix to make things faster. Default is to thin to 5000}

\item{method}{method for calculating correlations. Possible choices are "pearson" (default), "kendall" and "spearman"}

\item{whichParameters}{indices of parameters that should be plotted}

\item{...}{additional parameters to pass on to the \code{\link{getSample}}, for example parametersOnly =F, or start = 1000}
}
\description{
Flexible function to create correlation density plots
}
\examples{
dat = generateTestDensityMultiNormal(n = 100000, sample = TRUE)
correlationPlot(dat(100000))
}
\references{
The code for the correlation density plot originates from Hartig, F.; Dislich, C.; Wiegand, T. & Huth, A. (2014) Technical Note: Approximate Bayesian parameterization of a process-based tropical forest model. Biogeosciences, 11, 1261-1272.
}
\seealso{
\code{\link{marginalPlot}} \cr
         \code{\link{plotTimeSeries}} \cr
         \code{\link{tracePlot}} \cr
}
\author{
Florian Hartig
}
