% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPV_heatmap.R
\name{PPV_heatmap}
\alias{PPV_heatmap}
\title{Plot PPV and NPV heatmaps}
\usage{
PPV_heatmap(
  min_Prevalence = 1,
  max_Prevalence = 1000,
  Sensitivity = NULL,
  Specificity = NULL,
  limits_Sensitivity = NULL,
  limits_Specificity = NULL,
  one_out_of = FALSE,
  overlay = "no",
  overlay_labels = "",
  overlay_extra_info = FALSE,
  overlay_position_FP = NULL,
  overlay_position_FN = NULL,
  overlay_prevalence_1 = NULL,
  overlay_prevalence_2 = NULL,
  uncertainty_prevalence = "high",
  label_title = "",
  label_subtitle = "",
  Language = "en",
  folder = "",
  PPV_NPV = "PPV",
  steps_matrix = 100,
  DEBUG = FALSE,
  ...
)
}
\arguments{
\item{min_Prevalence}{[x] out of y prevalence of disease: [1-Inf]}

\item{max_Prevalence}{x out of [y] prevalence of disease: [1-Inf]}

\item{Sensitivity}{Sensitivity of test: [0-100]}

\item{Specificity}{Specificity of test: [0-100]}

\item{limits_Sensitivity}{c(min Sensitivity, max Sensitivity)}

\item{limits_Specificity}{c(min Specificity, max Specificity)}

\item{one_out_of}{Show y scale as 1 out of x [TRUE, FALSE] FALSE by default}

\item{overlay}{Type of overlay: ["line", "area"]}

\item{overlay_labels}{Labels for each point in the overlay. For example: c("80", "70", "60", "50", "40", "30", "20  y.o.")}

\item{overlay_extra_info}{show extra info in overlay? [TRUE/FALSE]}

\item{overlay_position_FP}{FP value (position in the x-axis) for each point in the overlay. For example: c(7, 8, 9, 12, 14, 14)}

\item{overlay_position_FN}{FN value (position in the x-axis) for each point in the overlay. For example: c(7, 8, 9, 12, 14, 14)}

\item{overlay_prevalence_1}{Prevalence value (position in the y-axis) for each point in the overlay. For example: c(1, 1, 1, 2, 1, 1)}

\item{overlay_prevalence_2}{Prevalence value (position in the y-axis) for each point in the overlay. For example: c(26, 29, 44, 69, 227, 1667)}

\item{uncertainty_prevalence}{How much certainty we have about the prevalence ["high"/"low"]}

\item{label_title}{Title for the plot}

\item{label_subtitle}{Subtitle for the plot}

\item{Language}{Language for the plot labels: ["sp", "en"]}

\item{folder}{Where to save the plot (the filename would be automatically created using the plot parameters)}

\item{PPV_NPV}{Should show PPV or NPV ["PPV", "NPV"]}

\item{steps_matrix}{width of PPV/NPV matrix. 100 by default}

\item{DEBUG}{Shows debug warnings [TRUE/FALSE]}

\item{...}{Other parameters. Now used to pass dpi, height and width in the Show and Save plot section}
}
\value{
Shows a plot or, if given a folder argument, saves a .png version of the plot
}
\description{
Plot heatmaps showing the PPV for a given Sensitivity and a range of Prevalences and False Positive values or NPV values for a given Specificity and a range of Prevalences and True Positive values
}
\examples{
PPV_heatmap(min_Prevalence = 1, 
max_Prevalence = 1000, 
Sensitivity = 100, 
Specificity = 98, 
Language = "en")
}
