% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/validation_MRMC_Create_dataList_MRMC_Hit_from_rate_etc.R
\name{false_and_its_rate_creator}
\alias{false_and_its_rate_creator}
\title{False Alarm Creator for both cases of MRMC and srsc}
\usage{
false_and_its_rate_creator(z.truth = BayesianFROC::z_truth, NI = 333,
  NL = 111, ModifiedPoisson = FALSE, seed = 12345)
}
\arguments{
\item{z.truth}{Vector of dimension = C represents the thresholds of bi-normal assumption.}

\item{NI}{The number of images.}

\item{NL}{The number of lesions.}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \emph{per lesion},
and model is fitted so that the FROC curve is a expected curve of TPF and FPF \emph{per lesion}.
If \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm is calculated \emph{per image},
and model is fitted so that the FROC curve is a expected curve of TPF and FPF \emph{per image}.
To know detail, see the author's paper in which I explained \emph{per image} and \emph{per lesion}.(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  })

If \code{ModifiedPoisson = TRUE},
 then the \emph{False Positive Fraction (FPF)} is calculated as follows
 (\eqn{f_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_L}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_L}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_L}, }

  \deqn{ \frac{f_4+f_5}{N_L}, }

   \deqn{ \frac{f_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_I}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_I}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_I}, }

  \deqn{ \frac{f_4+f_5}{N_I}, }

   \deqn{ \frac{f_5}{N_I}, }

where \eqn{N_I} is a number of images (trial).


The model is fitted so that the estimated FROC curve is on the FPF per image or per lesion accordingly.

If \code{ModifiedPoisson = TRUE}, then FROC curve means the expected pair of FPF \strong{per lesion} and TPF.

On the other hand, if  \code{ModifiedPoisson = FALSE}, then FROC curve means the expected pair of \strong{FPF per image} and TPF.




So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it uses only per images (trial). Since we can divide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author also developed FROC theory to consider FROC analysis under per signal.
One can see that the FROC curve is rigid with respect to change of a number of images, so, it does not matter whether \code{ModifiedPoisson = TRUE} or \code{FALSE}.

Revised 2019 August 28}

\item{seed}{The seed for creating false alarm which are generated by the Poisson  distributions using the specified seed.}
}
\value{
A list of vectors, indicating a true parameter and a sample.

A vector indicating a true parameter: False rate from thresholds.

A vector indicating a sample, more precisely,
The truth parameter of false alarm rate calculated by true thresholds \code{z} and
also, one-time drawn samples of false alarms from the calculated false rates.
}
\description{
From threshold, mean and S.D.,
data of False Alarm are created.
}
\details{
From threshold, mean and S.D.
of the latent Gaussian noise distribution
in the bi-normal assumption,
data of False Alarm are created.
For the process of this drawing false
 alarm samples, its rate are also created.
  So, in the return values of the function,
   the rates for each confidence level is also attached.
}
\examples{
 \donttest{
false.rate <- false_and_its_rate_creator()



#----------------------------------------------------------------------------------------
#  In SBC, Poisson rate = 0,..so,... i have to investigate.
#----------------------------------------------------------------------------------------

  set.seed( 1234 )

  dz <-runif(3,    # sample size
             0.01, # lower bound
             1     # upper bound
             )


  w  <- rnorm(1,
              0,
              1
              )

  z <- z_from_dz(w,dz  )


 false_and_its_rate_creator(z )



#----------------------------------------------------------------------------------------
#        Poisson rate  is OK
#----------------------------------------------------------------------------------------

  set.seed( 1234 )

  dz <-runif(3,    # sample size
             0.01, # lower bound
             1     # upper bound
             )


  w  <- rnorm(1,
              0,
              10 # It cause the  poisson rate become small
              )

  z <- z_from_dz(w,dz  )


 false_and_its_rate_creator(z )



#----------------------------------------------------------------------------------------
#  In SBC, Poisson rate is small
#----------------------------------------------------------------------------------------

  set.seed( 1234 )

  dz <-runif(3,    # sample size
             0.01, # lower bound
             1     # upper bound
             )


  w  <- rnorm(1,
              0,
              10 # It cause the  poisson rate become small
              )

  z <- z_from_dz(w,dz  )


 false_and_its_rate_creator(z )

#----------------------------------------------------------------------------------------
#               Poisson rate = 0
#----------------------------------------------------------------------------------------

  set.seed( 1234 )

  dz <-runif(3,    # sample size
             0.01, # lower bound
             10 # It cause the  poisson rate become exactly 0   # upper bound
             )


  w  <- rnorm(1,
              0,
              1
              )

  z <- z_from_dz(w,dz  )


 false_and_its_rate_creator(z )
#'}
}
