% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_message_on_imaging_device_rhat_values.R
\name{error_message_on_imaging_device_rhat_values}
\alias{error_message_on_imaging_device_rhat_values}
\title{Error message \strong{on a plot plane}(imaging device)}
\usage{
error_message_on_imaging_device_rhat_values(StanS4class, digits = 3)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{\link[rstan]{stanfit}}  that can be passed to the \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{digits}{digits to round r hat}
}
\description{
Since, shiny board fix user interface, and it let me make this;
in graphical device, the error message should be shown on its device.
So, usual functions such as \code{message()} or \code{cat()} cannot use in Shiny board.
Since, the UI is already made and it is graphical device!

If a fitted model converges, then the error message is none and thus only in R console,
the message is printed such as "A model converged." and does not print error message on a plot plane.
}
\details{
This is for non-convergent fitted model object, where convergence criteiron is R hat statistics for each model parameters.
}
\examples{
#========================================================================================
#   Non convergent fitting and error of it on graphic device
#========================================================================================
 \donttest{

 # Creat a fitted model object which does not converge with R hat criterion:

 fit <- fit_Bayesian_FROC( ite  = 111,
                            cha = 1,
                        summary = T,
                Null.Hypothesis = F,
                       dataList = dd # Here, non convergent data
                         )


# Nothing is plotted:

plot(0,0,
     type ="n",
     axes =FALSE,
     ann=FALSE
     )


 # Error message on the above graphic device:

error_message_on_imaging_device_rhat_values(fit)

#========================================================================================
#      The author use in this packae as following manner:
#========================================================================================


        DrawCurves(fit)



# It does not work , and it is ,,, Ok since when non converges I will want to see
# plot, so this function is no need.

 # 2019 August 18
}#donttest
}
