% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-averaging.R
\name{ensemble_inference}
\alias{ensemble_inference}
\alias{compute_inference}
\alias{models_inference}
\title{Compute posterior probabilities and inclusion Bayes factors}
\usage{
compute_inference(prior_weights, margliks, is_null = NULL, conditional = FALSE)

ensemble_inference(model_list, parameters, is_null_list, conditional = FALSE)

models_inference(model_list)
}
\arguments{
\item{prior_weights}{vector of prior model odds}

\item{margliks}{vector of marginal likelihoods}

\item{is_null}{logical vector of indicators specifying whether the model corresponds
to the null or alternative hypothesis (or an integer vector indexing models
corresponding to the null hypothesis)}

\item{conditional}{whether prior and posterior model probabilities should
be returned only for the conditional model. Defaults to \code{FALSE}}

\item{model_list}{list of models, each of which contains marginal
likelihood estimated with bridge sampling \code{marglik} and prior model
odds \code{prior_weights}}

\item{parameters}{vector of parameters names for which inference should
be drawn}

\item{is_null_list}{list with entries for each parameter carrying either
logical vector of indicators specifying whether the model corresponds
to the null or alternative hypothesis (or an integer vector indexing models
corresponding to the null hypothesis)}
}
\value{
\code{compute_inference} returns a named list of prior probabilities,
posterior probabilities, and Bayes factors, \code{ppoint} gives the
distribution function, \code{ensemble_inference} gives a list of named lists of
inferences for each parameter, and \code{models_inference} returns a list of
models, each expanded by the inference list.
}
\description{
Computes prior probabilities, posterior probabilities,
and inclusion Bayes factors based either on (1) a list of models,
vector of parameters, and a list of indicators the models represent the
null or alternative hypothesis for each parameter, (2) on prior
model odds, marginal likelihoods, and indicator whether
the models represent the null or alternative hypothesis, or (3) list of
models for each model.
}
\seealso{
\link{mix_posteriors} \link{BayesTools_ensemble_tables}
}
