% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNetwork.R
\name{plotNetwork}
\alias{plotNetwork}
\title{plot the network representation of the associations between responses and predictors}
\usage{
plotNetwork(object, includeResponse = NULL, excludeResponse = NULL,
  includePredictor = NULL, excludePredictor = NULL,
  MatrixGamma = NULL, PmaxPredictor = 0.5, PmaxResponse = 0.5,
  nodesizePredictor = 5, nodesizeResponse = 25, no.isolates = FALSE,
  lineup = 1, gray.alpha = 0.6, edgewith.response = 5,
  edgewith.predictor = 2, edge.weight = FALSE,
  label.predictor = NULL, label.response = NULL,
  color.predictor = NULL, color.response = NULL,
  name.predictors = NULL, name.responses = NULL,
  vertex.frame.color = NA, layoutInCircle = FALSE, header = "", ...)
}
\arguments{
\item{object}{an object of class "BayesSUR"}

\item{includeResponse}{A vector of the response names which are shown in the network}

\item{excludeResponse}{A vector of the response names which are not shown in the network}

\item{includePredictor}{A vector of the predictor names which are shown in the network}

\item{excludePredictor}{A vector of the predictor names which are not shown in the network}

\item{MatrixGamma}{A matrix or dataframe of the latent indicator variable. Default is \code{NULL} and to extrate it from object of class inheriting from an object of class "BayesSUR"}

\item{PmaxPredictor}{cutpoint for thresholding the estimated latent indicator variable. Default is 0.5}

\item{PmaxResponse}{cutpoint for thresholding the learning structure matrix of multiple response variables. Default is 0.5}

\item{nodesizePredictor}{node size of Predictors in the output graph. Default is 15}

\item{nodesizeResponse}{node size of response variables in the output graph. Default is 25}

\item{no.isolates}{remove isolated nodes from responses graph and Full graph, may get problem if there are also isolated Predictors}

\item{lineup}{A ratio of the heights between responses' area and Predictors'}

\item{gray.alpha}{the opacity. The default is 0.6}

\item{edgewith.response}{the edge width betwen response nodes}

\item{edgewith.predictor}{the edge width betwen the predictor and response node}

\item{edge.weight}{draw weighted edges after thresholding at 0.5. The defaul value \code{FALSE} is not to draw weigthed edges}

\item{label.predictor}{A vector of the names of predictors}

\item{label.response}{A vector of the names of response variables}

\item{color.predictor}{color of the predictor nodes}

\item{color.response}{color of the reponse nodes}

\item{name.predictors}{a subtitle for the predictors}

\item{name.responses}{a subtitle for the responses}

\item{vertex.frame.color}{The color of the frame of the vertices. If you don't want vertices to have a frame, supply NA as the color name}

\item{layoutInCircle}{place vertices on a circle, in the order of their vertex ids. The default is \code{FALSE}}

\item{header}{the main title}

\item{...}{other arguments}
}
\description{
Plot the network representation of the associations between responses and predictors, based on the estimated gamma matrix and graph of responses from a "BayesSUR" class object.
}
\examples{
data("example_eQTL", package = "BayesSUR")
hyperpar <- list( a_w = 2 , b_w = 5 )

fit <- BayesSUR(Y = example_eQTL[["blockList"]][[1]], 
                X = example_eQTL[["blockList"]][[2]],
                data = example_eQTL[["data"]], outFilePath = tempdir(),
                nIter = 100, burnin = 50, nChains = 2, gammaPrior = "hotspot",
                hyperpar = hyperpar, tmpFolder = "tmp/" )

## check output
# show the Network representation of the associations between responses and features
plotNetwork(fit)

}
