% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_blc_pred.R
\name{quantile.PredBLC}
\alias{quantile.PredBLC}
\title{BLC: Sample quantiles for predictions}
\usage{
\method{quantile}{PredBLC}(x, q, h, ...)
}
\arguments{
\item{x}{A \code{PredBLC} object, result to the pred() function call on a \code{BLC} object.}

\item{q}{A real number that represents the probability of the quantiles.}

\item{h}{A positive integer especifying the year in the prediciton horizon to be calculated.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A data.frame with the quantiles of the selected parameter.
}
\description{
Calculates the quantiles of log-mortality based on the resulting chains from a predicted year.
}
\examples{
## Importing log-mortality data from Portugal:
data(PT)
Y <- PT

## Fitting the model
fit = blc(Y = Y, M = 100, bn = 20)

## Prediction for 2 years ahead
pred = predict(fit, h = 2)

## The log-mortality median for the first year of prediction
quantile(pred, q = 0.5, h = 1)

## The 0.1 and 0.9 quantiles for the first and second year of prediction
quantile(pred, q = c(0.1, 0.9), h = 1)
quantile(pred, q = c(0.1, 0.9), h = 2)

}
\seealso{
\code{\link[=quantile.BLC]{quantile.BLC()}} for \code{BLC} method.
}
