% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_dlm.R
\name{Heatmap.DLM}
\alias{Heatmap.DLM}
\title{DLM: Heatmap for the life expectancy.}
\usage{
\method{Heatmap}{DLM}(
  x,
  x_lab,
  age = NULL,
  max_age = 110,
  color = c("red", "white", "blue"),
  ...
)
}
\arguments{
\item{x}{Object or a list of objects of the class \code{DLM} or \code{ClosedDLM} returned by dlm() or dlm_close() functions.}

\item{x_lab}{Description of the object 'fit'.}

\item{age}{Vector with the ages to plot the heatmap.}

\item{max_age}{Positive number indicating the last age to be considered to compute the life expectancy (prediction will be considered to match the age interval if needed). This argument is only necessary with objects of the class \code{DLM}.}

\item{color}{Vector of colours used in the heatmap.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A ggplot2 heatmap of the life expectancy.
}
\description{
This function plots a heatmap for the life expectancy of the fitted DLMs.
}
\examples{
## Importing mortality data from the USA available on the Human Mortality Database (HMD):
data(USA)

# Example 1: -------------------------------

USA2010 = USA[USA$Year == 2010,]

ExF = USA2010$Ex.Female[1:91]
DxF = USA2010$Dx.Female[1:91]

qx_tF <- DxF/ExF
qx_tF <- 1 - exp(-qx_tF)
yF <- log(qx_tF)

fitF <- dlm(yF, M = 100, bn = 20, thin = 1)

Heatmap(fitF, x_lab = "Female expec. 2010 USA", max_age = 90)


}
\seealso{
\code{\link[=Heatmap.BLC]{Heatmap.BLC()}} and \code{\link[=Heatmap.HP]{Heatmap.HP()}} for \code{BLC} or \code{HP} methods.

\code{\link[=Heatmap.list]{Heatmap.list()}} to the \code{list} method, adding multiple objects in one single Heatmap.
}
