% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialisers.R
\name{initialise.allsame}
\alias{initialise.allsame}
\title{Initialises all parameters of the network, all hyper parameters
of the prior and all additional parameters
of the likelihood by drawing random values from `dist`.}
\usage{
initialise.allsame(dist, like, prior)
}
\arguments{
\item{dist}{A distribution; See for example \code{\link{Normal}}}

\item{like}{A likelihood; See for example \code{\link{likelihood.feedforward_normal}}}

\item{prior}{A prior; See for example \code{\link{prior.gaussian}}}
}
\value{
A list containing the following
\itemize{
    \item `juliavar` - julia variable storing the initialiser
    \item `juliacode` - julia code used to create the initialiser
}
}
\description{
Initialises all parameters of the network, all hyper parameters
of the prior and all additional parameters
of the likelihood by drawing random values from `dist`.
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  BNN.totparams(bnn)
}

}
