% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_mcmc.R
\name{BayesFBHborrow.NoBorrow}
\alias{BayesFBHborrow.NoBorrow}
\title{Run the MCMC sampler without Bayesian Borrowing}
\usage{
\method{BayesFBHborrow}{NoBorrow}(
  data,
  data_hist = NULL,
  tuning_parameters,
  initial_values = NULL,
  hyperparameters = list(a_sigma = 1, b_sigma = 1, phi = 3, clam_smooth = 0.8),
  lambda_hyperparameters = list(a_lambda = 0.01, b_lambda = 0.01),
  iter = 150,
  warmup_iter = 10,
  refresh = 0,
  verbose = FALSE,
  max_grid = 2000
)
}
\arguments{
\item{data}{data.frame containing atleast three vectors of "tte" (time-to-event)
and "event" (event indicator), and covariates "X_i" (where i should be a number/
indicator of the covariate)}

\item{data_hist}{NULL (not used)}

\item{tuning_parameters}{list of "cprop_beta", "Jmax", and "pi_b"}

\item{initial_values}{list containing the initial values of c("J", "s_r",
"mu", "sigma2", "lambda", beta") (optional)}

\item{hyperparameters}{list containing the hyperparameters c("a_sigma",
"b_sigma", "Jmax", "clam_smooth", "cprop_beta", "phi"). Default is 
list("a_sigma" = 2, "b_sigma" = 2, "Jmax" = 20, "clam_smooth" = 0.8, 
"cprop_beta" = 0.3, "phi" = 3)}

\item{lambda_hyperparameters}{contains two hyperparameters ("a" and "b") used for
the update of lambda, default is c(0.01, 0.01)}

\item{iter}{number of iterations for MCMC sampler. Default is 2000}

\item{warmup_iter}{number of warmup iterations (burn-in) for MCMC sampler. 
Default is 2000}

\item{refresh}{number of iterations between printed console updates. Default
is 0}

\item{verbose}{TRUE (default), choice of output, if TRUE will output 
intermittent results into console}

\item{max_grid}{grid size for the smoothed baseline hazard. Default is 2000}
}
\value{
list of samples for both fixed (can be found in $out_fixed) and 
multidimensional parameters (lambda, s, tau)
}
\description{
Main function of the BayesFBHborrow package. This generic function 
calls the correct MCMC sampler for time-to-event without Bayesian borrowing.
}
\examples{
set.seed(123)
# Load the example data and write your initial values and hyper parameters
data(piecewise_exp_cc, package = "BayesFBHborrow")

# Set your hyperparameters and tuning parameters
hyper <-  list("a_sigma" = 2,
               "b_sigma" = 2,
               "clam_smooth" = 0.5,
               "phi" = 3)

tuning_parameters <- list("Jmax" = 5,
                          "pi_b" = 0.5,
                          "cprop_beta" = 0.5)
                          
# Set initial values to default
out <- BayesFBHborrow(piecewise_exp_cc, NULL, tuning_parameters,
                      initial_values = NULL, hyper, iter = 5, warmup_iter = 1)
}
