% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coveff.R
\name{print_coveff}
\alias{print_coveff}
\title{Format the covariate effect simulation results for printing}
\usage{
print_coveff(
  coveffsim,
  n_sigfig = 3,
  use_seps = TRUE,
  drop_trailing_dec_mark = TRUE
)
}
\arguments{
\item{coveffsim}{an object of class \code{coveffsim}}

\item{n_sigfig}{Number of significant figures to form value_label of
continuous variables. See \code{\link[gt:vec_fmt_number]{gt::vec_fmt_number()}} for details.}

\item{use_seps}{Whether to use separators for thousands in printing numbers.
See \code{\link[gt:vec_fmt_number]{gt::vec_fmt_number()}} for details.}

\item{drop_trailing_dec_mark}{Whether to drop the trailing decimal mark
(".") in value_label of continuous variables. See \code{\link[gt:vec_fmt_number]{gt::vec_fmt_number()}}
for details.}
}
\value{
A data frame with the formatted covariate effect simulation results
with the following columns:
\itemize{
\item \code{var_label}: the label of the covariate
\item \code{value_label}: the label of the covariate value
\item \code{value_annot}: the annotation of the covariate value
\item \verb{Odds ratio}: the odds ratio of the covariate effect
\item \verb{95\% CI}: the 95\% credible interval of the covariate effect
}
}
\description{
Format the covariate effect simulation results for printing
}
\details{
Note that \code{n_sigfig}, \code{use_seps}, and \code{drop_trailing_dec_mark} are only
applied to the odds ratio and 95\% CI columns; value_label column was
already generated in an earlier step in \code{\link[=build_spec_coveff]{build_spec_coveff()}} or
\code{\link[=sim_coveff]{sim_coveff()}}.
}
\examples{
\dontshow{if (BayesERtools:::.if_run_ex_coveff()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
data(d_sim_binom_cov_hgly2)

ermod_bin <- dev_ermod_bin(
  data = d_sim_binom_cov_hgly2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov = "BHBA1C_5",
)

print_coveff(sim_coveff(ermod_bin))
}
\dontshow{\}) # examplesIf}
}
