% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barline.R
\name{barline}
\alias{barline}
\title{Draws a bar-line plot}
\usage{
barline(
  data,
  id,
  bars,
  line,
  order.by = id,
  decreasing = TRUE,
  labels.bars = NULL,
  label.line = NULL,
  position.bars = "stack",
  title = NULL
)
}
\arguments{
\item{data}{a data frame.}

\item{id}{character, name of the ID variable.}

\item{bars}{character vector, names of the bar variables.}

\item{line}{character, name of the line variable.}

\item{order.by}{character, name of the variable used to order bars (on the x-axis).}

\item{decreasing}{logical; if \code{TRUE}, decreasing order.}

\item{labels.bars}{character vector, labels for the bar variables.}

\item{label.line}{character, label for the line variable on the second y-axis (on the right).}

\item{position.bars}{character, used to adjust the positioning of the bars in the plot; there are four main options: \code{stack}, \code{fill}, \code{dodge}, and \code{identity}.}

\item{title}{character, plot title.}
}
\value{
A \code{ggplot2} object
}
\description{
Draws a bar-line plot
}
\examples{
dts <- subset(Pbox, Team=="Houston Rockets" & MIN>=500)
barline(data=dts, id="Player", bars=c("P2p","P3p","FTp"),
        line="MIN", order.by="Player",
        labels.bars=c("2P","3P","FT"), title="Houston Rockets")
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{	basketballanalyzer.help@unibs.it})
}
