% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_elements}
\alias{add_elements}
\title{Add elements to a TidySet}
\usage{
add_elements(object, elements, ...)
}
\arguments{
\item{object}{A \code{\link{TidySet}} object}

\item{elements}{A character vector of the elements.}

\item{...}{Placeholder for other arguments that could be passed to the
method. Currently not used.}
}
\value{
A \code{\link{TidySet}} object with the new elements.
}
\description{
Functions to add elements. If the elements are new they are added,
otherwise they are omitted.
}
\note{
\code{add_element} doesn't set up any other information about the elements.
Remember to add/modify them if needed with \code{\link{mutate}} or \code{\link{mutate_element}}
}
\examples{
x <- list("a" = letters[1:5], "b" = LETTERS[3:7])
a <- tidySet(x)
b <- add_elements(a, "fg")
elements(b)
}
\seealso{
Other add_*: 
\code{\link{add_relations}()},
\code{\link{add_sets}()}
}
\concept{add_*}
