% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/names.R
\name{name_sets}
\alias{name_sets}
\alias{name_sets,TidySet-method}
\alias{name_sets<-,TidySet,characterORfactor-method}
\title{Name sets}
\usage{
name_sets(object)

\S4method{name_sets}{TidySet}(object)

\S4method{name_sets}{TidySet,characterORfactor}(object) <- value
}
\arguments{
\item{object}{A TidySet object.}

\item{value}{A character with the new names for the sets.}
}
\value{
A \code{TidySet} object.
}
\description{
Retrieve the name of the sets.
}
\section{Methods (by class)}{
\itemize{
\item \code{TidySet}: Name sets

\item \code{object = TidySet,value = characterORfactor}: Rename sets
}}

\examples{
relations <- data.frame(
    sets = c(rep("A", 5), "B"),
    elements = letters[seq_len(6)],
    fuzzy = runif(6)
)
TS <- tidySet(relations)
name_sets(TS)
}
\seealso{
Other names: 
\code{\link{name_elements<-}()},
\code{\link{name_elements}()},
\code{\link{name_sets<-}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
\concept{names}
