% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Substance.R
\name{Substance-constructor}
\alias{Substance-constructor}
\alias{Substance}
\title{Constructor of the S4 class \code{Substance}}
\usage{
Substance(n, m, smax, gridgeometry, difspeed = 0.02412, advspeed = 0,
  occupyM, Dgrid = NULL, Vgrid = NULL, diffmat = NULL,
  template = FALSE, ...)
}
\arguments{
\item{n}{A number giving the horizontal size of the environment.}

\item{m}{A number giving the vertical size of the environment.}

\item{smax}{A number representing the start concentration of the substance for each grid cell in the environment.}

\item{gridgeometry}{A list containing grid geometry parameter}

\item{difspeed}{A number indicating the diffusion speed in x and y direction (given by cm^2/h). For more complex setup define Dgrid.}

\item{advspeed}{A number indicating the advection speed in x direction (given by cm/h). For more complex setup define Vgrid.}

\item{occupyM}{A matrix indicating grid cells that are obstacles}

\item{Dgrid}{A matrix indicating the diffusion speed in x and y direction (given by cm^2/h).}

\item{Vgrid}{A number indicating the advection speed in x direction (given by cm/h).}

\item{diffmat}{A matrix with spatial distributed initial concentrations (unit in fmol) (if not set, a homogenous matrix using smax is created)}

\item{template}{True if diffmat matrix should be used as tempalte only (will be multiplied with smax to obtain cocentrations)}

\item{...}{Arguments of \code{\link{Substance-class}}}
}
\value{
Object of class \code{Substance}
}
\description{
The constructor to get a new object of class \code{Substance}
}
